/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.styleablefx.skins;

import com.sun.javafx.scene.control.skin.ButtonSkin;
import de.saxsys.styleablefx.additions.SVGStyleableAddition;
import de.saxsys.styleablefx.controls.SVGGroup;
import de.saxsys.styleablefx.core.IStyleableAdditionProvider;
import de.saxsys.styleablefx.core.StyleableAdditionBase;
import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;

public class SVGButtonSkin
extends ButtonSkin
implements IStyleableAdditionProvider {
    public static final String SVG_COMPOUND_SELECTOR = "svg-data";
    private double originalWidth;
    private double originalHeight;
    protected final SVGGroup svgData = new SVGGroup();

    public SVGButtonSkin(Button button) {
        super(button);
        this.svgData.getStyleClass().setAll((Object[])new String[]{SVG_COMPOUND_SELECTOR});
        button.setGraphic((Node)this.svgData);
        button.widthProperty().addListener(this::onWidthChanged);
        button.heightProperty().addListener(this::onHeightChanged);
        button.graphicProperty().addListener(this::onGraphicChanged);
    }

    private void onWidthChanged(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        if (this.originalWidth <= 0.0) {
            this.originalWidth = newValue.doubleValue();
        }
        if (this.originalWidth > 0.0) {
            this.svgData.setScaleX(((Button)this.getSkinnable()).widthProperty().getValue() / this.originalWidth);
        }
    }

    private void onHeightChanged(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        if (this.originalHeight <= 0.0) {
            this.originalHeight = newValue.doubleValue();
        }
        if (this.originalHeight > 0.0) {
            this.svgData.setScaleY(((Button)this.getSkinnable()).heightProperty().getValue() / this.originalHeight);
        }
    }

    private void onGraphicChanged(ObservableValue<? extends Node> observable, Node oldValue, Node newValue) {
        if (newValue != this.svgData) {
            ((Button)this.getSkinnable()).graphicProperty().set((Object)this.svgData);
        }
    }

    @Override
    public <TStyleableAddition extends StyleableAdditionBase> Optional<TStyleableAddition> getStyleableAddition(Class<TStyleableAddition> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Given clazz must not be null");
        }
        if (clazz.equals(SVGStyleableAddition.class)) {
            return this.svgData.getStyleableAddition(clazz);
        }
        return Optional.empty();
    }
}

