/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.styleablefx.core;

import de.saxsys.styleablefx.core.IStyleableAdditionProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.scene.control.Control;

public abstract class StyleableAdditionBase {
    public static <TStyleableAddition extends StyleableAdditionBase> TStyleableAddition getStyleableAddition(Styleable styleable, Class<TStyleableAddition> clazz) {
        if (styleable == null) {
            throw new IllegalArgumentException("Given styleable is null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Given class must not be null");
        }
        Optional<Object> styleableAddition = Optional.empty();
        if (styleable instanceof IStyleableAdditionProvider) {
            styleableAddition = ((IStyleableAdditionProvider)IStyleableAdditionProvider.class.cast(styleable)).getStyleableAddition(clazz);
        }
        if (!styleableAddition.isPresent() && styleable instanceof Control && ((Control)styleable).getSkin() != null) {
            styleableAddition = ((IStyleableAdditionProvider)IStyleableAdditionProvider.class.cast(((Control)styleable).getSkin())).getStyleableAddition(clazz);
        }
        if (!styleableAddition.isPresent()) {
            throw new IllegalArgumentException(String.format("Given StyleableAdditionBase for clazz %s was not found on provided styleable %s", clazz.getName(), styleable.getClass().getName()));
        }
        return (TStyleableAddition)((StyleableAdditionBase)styleableAddition.get());
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return new ArrayList();
    }
}

