/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.styleablefx.additions;

import de.saxsys.styleablefx.core.StyleableAdditionBase;
import de.saxsys.svgfx.core.SVGParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.Group;
import javafx.scene.shape.SVGPath;
import org.xml.sax.SAXParseException;

public class SVGStyleableAddition
extends StyleableAdditionBase {
    static final CssMetaData<Styleable, String> SVG_URL = new CssMetaData<Styleable, String>("-saxsys-svg-url", StyleConverter.getStringConverter(), null){

        public boolean isSettable(Styleable node) {
            return !StyleableAdditionBase.getStyleableAddition(node, SVGStyleableAddition.class).svgUrl.isBound();
        }

        public StyleableProperty<String> getStyleableProperty(Styleable node) {
            return (StyleableProperty)StyleableAdditionBase.getStyleableAddition(node, SVGStyleableAddition.class).svgUrl;
        }
    };
    static final CssMetaData<Styleable, Boolean> WILL_CACHE_SVG = new CssMetaData<Styleable, Boolean>("-saxsys-will-cache-svg", StyleConverter.getBooleanConverter(), Boolean.valueOf(true)){

        public boolean isSettable(Styleable node) {
            return !StyleableAdditionBase.getStyleableAddition(node, SVGStyleableAddition.class).willCacheSvg.isBound();
        }

        public StyleableProperty<Boolean> getStyleableProperty(Styleable node) {
            return (StyleableProperty)StyleableAdditionBase.getStyleableAddition(node, SVGStyleableAddition.class).willCacheSvgProperty();
        }
    };
    private final SVGParser parser;
    private final Group svgGroup = new Group();
    private final Map<String, Group> svgData = new HashMap<String, Group>();
    private final ObjectProperty<String> svgUrl = new SimpleStyleableObjectProperty(SVG_URL, (Object)this, "svgUrl", null);
    private final ObjectProperty<Boolean> willCacheSvg = new SimpleStyleableObjectProperty(WILL_CACHE_SVG, (Object)this, "willCacheSvg", (Object)true);

    public SVGStyleableAddition() {
        this.svgUrlProperty().addListener(this::loadSVG);
        this.parser = new SVGParser();
    }

    public final Group getSvgGroup() {
        return this.svgGroup;
    }

    public final String getSvgUrl() {
        return (String)this.svgUrl.get();
    }

    public final void setSvgUrl(String value) {
        this.svgUrl.set((Object)value);
    }

    public final Boolean getWillCacheSvg() {
        return (Boolean)this.willCacheSvg.get();
    }

    public final void setWillCacheSvg(Boolean value) {
        this.willCacheSvg.set((Object)value);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private void loadSVG(ObservableValue<? extends String> observable, String oldValue, String newValue) throws IllegalArgumentException, ParseException {
        if (newValue != null) {
            Group data;
            File file;
            try {
                file = this.getFile(newValue);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Uri of file is malformed.", e);
            }
            if (file == null || !file.isFile() || !file.exists()) {
                throw new IllegalArgumentException(new FileNotFoundException(String.format("Given file %s does not exist or is not a file.", newValue)));
            }
            this.svgGroup.getChildren().clear();
            try {
                data = this.getData(file);
            }
            catch (IOException | NoSuchMethodException | SAXParseException e) {
                throw new ParseException("Error during parsing of the svg file", e);
            }
            this.svgGroup.getChildren().add((Object)data);
        }
    }

    private File getFile(String filepath) throws URISyntaxException {
        File file = new File(filepath);
        if (file.isFile()) {
            return file;
        }
        URL url = this.getClass().getClassLoader().getResource(filepath);
        if (url != null && (file = new File(url.toURI())).isFile()) {
            return file;
        }
        return null;
    }

    private Group getData(File file) throws NoSuchMethodException, SAXParseException, IOException {
        Group result;
        if (!this.getWillCacheSvg().booleanValue()) {
            result = this.loadData(file);
        } else {
            result = this.svgData.get(file.getAbsolutePath());
            if (result == null) {
                result = this.loadData(file);
                this.svgData.put(file.getAbsolutePath(), result);
            }
        }
        return result;
    }

    private Group loadData(File file) throws NoSuchMethodException, SAXParseException, IOException {
        this.parser.parse(file);
        Group result = (Group)this.parser.getResult();
        this.parser.clear();
        return result;
    }

    public final ObjectProperty<String> svgUrlProperty() {
        return this.svgUrl;
    }

    public final ObjectProperty<Boolean> willCacheSvgProperty() {
        return this.willCacheSvg;
    }

    public void addPath(SVGPath path) {
        this.svgGroup.getChildren().add((Object)path);
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<Object> styleables = new ArrayList<Object>();
            styleables.add(SVG_URL);
            styleables.add(WILL_CACHE_SVG);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public class ParseException
    extends RuntimeException {
        public ParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

