/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.commands;

import de.saxsys.mvvmfx.utils.commands.Action;
import de.saxsys.mvvmfx.utils.commands.Command;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Service;
import javafx.concurrent.Task;

public class DelegateCommand
extends Service<Void>
implements Command {
    private final Supplier<Action> actionSupplier;
    private boolean inBackground = false;
    protected final ReadOnlyBooleanWrapper executable = new ReadOnlyBooleanWrapper(true);
    protected ReadOnlyBooleanWrapper notExecutable;
    protected ReadOnlyBooleanWrapper notRunning;

    public DelegateCommand(Supplier<Action> actionSupplier) {
        this(actionSupplier, false);
    }

    public DelegateCommand(Supplier<Action> actionSupplier, boolean inBackground) {
        this(actionSupplier, null, inBackground);
    }

    public DelegateCommand(Supplier<Action> actionSupplier, ObservableValue<Boolean> executableObservable) {
        this(actionSupplier, executableObservable, false);
    }

    public DelegateCommand(Supplier<Action> actionSupplier, ObservableValue<Boolean> executableObservable, boolean inBackground) {
        this.actionSupplier = actionSupplier;
        this.inBackground = inBackground;
        if (executableObservable != null) {
            this.executable.bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                boolean isRunning = this.runningProperty().get();
                boolean isExecutable = (Boolean)executableObservable.getValue();
                return !isRunning && isExecutable;
            }, (Observable[])new Observable[]{this.runningProperty(), executableObservable}));
        }
    }

    @Override
    public void execute() {
        if (!this.isExecutable()) {
            throw new RuntimeException("The execute()-method of the command was called while it wasn't executable.");
        }
        if (this.inBackground) {
            if (!super.isRunning()) {
                this.reset();
                this.start();
            }
        } else {
            try {
                this.actionSupplier.get().action();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected Task<Void> createTask() {
        return this.actionSupplier.get();
    }

    @Override
    public ReadOnlyBooleanProperty executableProperty() {
        return this.executable.getReadOnlyProperty();
    }

    @Override
    public boolean isExecutable() {
        return this.executableProperty().get();
    }

    @Override
    public final ReadOnlyBooleanProperty notExecutableProperty() {
        if (this.notExecutable == null) {
            this.notExecutable = new ReadOnlyBooleanWrapper();
            this.notExecutable.bind((ObservableValue)this.executableProperty().not());
        }
        return this.notExecutable.getReadOnlyProperty();
    }

    @Override
    public final boolean isNotExecutable() {
        return this.notExecutableProperty().get();
    }

    @Override
    public final ReadOnlyBooleanProperty notRunningProperty() {
        if (this.notRunning == null) {
            this.notRunning = new ReadOnlyBooleanWrapper();
            this.notRunning.bind((ObservableValue)this.runningProperty().not());
        }
        return this.notRunning.getReadOnlyProperty();
    }

    @Override
    public final boolean isNotRunning() {
        return this.notRunningProperty().get();
    }
}

