/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.notifications;

import de.saxsys.mvvmfx.utils.notifications.NotificationObserver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.util.Pair;

public class NotificationTestHelper
implements NotificationObserver {
    public static final long DEFAULT_TIMEOUT = 0L;
    private List<Pair<String, Object[]>> notifications = new ArrayList<Pair<String, Object[]>>();
    private long timeout = 0L;

    public NotificationTestHelper() {
        new JFXPanel();
    }

    public NotificationTestHelper(long timeoutInMillis) {
        this();
        this.timeout = timeoutInMillis;
    }

    @Override
    public void receivedNotification(String key, Object ... payload) {
        this.notifications.add((Pair<String, Object[]>)new Pair((Object)key, (Object)payload));
    }

    public int numberOfReceivedNotifications() {
        this.waitForUiThread();
        return this.notifications.size();
    }

    public int numberOfReceivedNotifications(String key) {
        this.waitForUiThread();
        return (int)this.notifications.stream().filter(pair -> ((String)pair.getKey()).equals(key)).count();
    }

    private void waitForUiThread() {
        CompletableFuture future = new CompletableFuture();
        Platform.runLater(() -> {
            if (this.timeout > 0L) {
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            future.complete(null);
        });
        try {
            future.get(this.timeout + 50L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            e.printStackTrace();
        }
    }
}

