/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.notifications;

import de.saxsys.mvvmfx.ViewModel;
import de.saxsys.mvvmfx.utils.notifications.NotificationCenter;
import de.saxsys.mvvmfx.utils.notifications.NotificationObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultNotificationCenter
implements NotificationCenter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNotificationCenter.class);
    private final ObserverMap globalObservers = new ObserverMap();
    private final ViewModelObservers viewModelObservers = new ViewModelObservers();

    DefaultNotificationCenter() {
    }

    @Override
    public void subscribe(String messageName, NotificationObserver observer) {
        this.addObserver(messageName, observer, this.globalObservers);
    }

    @Override
    public void unsubscribe(String messageName, NotificationObserver observer) {
        this.removeObserversForMessageName(messageName, observer, this.globalObservers);
    }

    @Override
    public void unsubscribe(NotificationObserver observer) {
        this.removeObserverFromObserverMap(observer, this.globalObservers);
    }

    @Override
    public void publish(String messageName, Object ... payload) {
        this.publish(messageName, payload, this.globalObservers);
    }

    @Override
    public void publish(ViewModel viewModel, String messageName, Object[] payload) {
        if (this.viewModelObservers.containsKey(viewModel)) {
            ObserverMap observerMap = (ObserverMap)this.viewModelObservers.get(viewModel);
            if (Platform.isFxApplicationThread()) {
                this.publish(messageName, payload, observerMap);
            } else {
                try {
                    Platform.runLater(() -> this.publish(messageName, payload, observerMap));
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().equals("Toolkit not initialized")) {
                        this.publish(messageName, payload, observerMap);
                    }
                    throw e;
                }
            }
        }
    }

    @Override
    public void subscribe(ViewModel viewModel, String messageName, NotificationObserver observer) {
        if (!this.viewModelObservers.containsKey(viewModel)) {
            this.viewModelObservers.put(viewModel, new ObserverMap());
        }
        ObserverMap observerMap = (ObserverMap)this.viewModelObservers.get(viewModel);
        this.addObserver(messageName, observer, observerMap);
    }

    @Override
    public void unsubscribe(ViewModel viewModel, String messageName, NotificationObserver observer) {
        if (this.viewModelObservers.containsKey(viewModel)) {
            ObserverMap observerMap = (ObserverMap)this.viewModelObservers.get(viewModel);
            this.removeObserversForMessageName(messageName, observer, observerMap);
        }
    }

    @Override
    public void unsubscribe(ViewModel viewModel, NotificationObserver observer) {
        if (this.viewModelObservers.containsKey(viewModel)) {
            ObserverMap observerMap = (ObserverMap)this.viewModelObservers.get(viewModel);
            this.removeObserverFromObserverMap(observer, observerMap);
        }
    }

    private void publish(String messageName, Object[] payload, ObserverMap observerMap) {
        Collection notificationReceivers = (Collection)observerMap.get(messageName);
        if (notificationReceivers != null) {
            ArrayList copy = new ArrayList(notificationReceivers);
            for (NotificationObserver observer : copy) {
                observer.receivedNotification(messageName, payload);
            }
        }
    }

    private void addObserver(String messageName, NotificationObserver observer, ObserverMap observerMap) {
        List observers;
        if (!observerMap.containsKey(messageName)) {
            observerMap.put(messageName, new ArrayList());
        }
        if ((observers = (List)observerMap.get(messageName)).contains(observer)) {
            LOG.warn("Subscribe the observer [" + observer + "] for the message [" + messageName + "], but the same observer was already added for this message in the past.");
        }
        observers.add(observer);
    }

    private void removeObserverFromObserverMap(NotificationObserver observer, ObserverMap observerMap) {
        for (String key : observerMap.keySet()) {
            List observers = (List)observerMap.get(key);
            observers.removeIf(actualObserver -> actualObserver.equals(observer));
        }
    }

    private void removeObserversForMessageName(String messageName, NotificationObserver observer, ObserverMap observerMap) {
        if (observerMap.containsKey(messageName)) {
            List observers = (List)observerMap.get(messageName);
            observers.removeIf(actualObserver -> actualObserver.equals(observer));
            if (observers.size() == 0) {
                observerMap.remove(messageName);
            }
        }
    }

    private class ViewModelObservers
    extends HashMap<ViewModel, ObserverMap> {
        private ViewModelObservers() {
        }
    }

    private class ObserverMap
    extends HashMap<String, List<NotificationObserver>> {
        private ObserverMap() {
        }
    }
}

