/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.internal.viewloader;

import de.saxsys.mvvmfx.InjectViewModel;
import de.saxsys.mvvmfx.ViewModel;
import de.saxsys.mvvmfx.internal.viewloader.DependencyInjector;
import de.saxsys.mvvmfx.internal.viewloader.ReflectionUtils;
import de.saxsys.mvvmfx.internal.viewloader.View;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.jodah.typetools.TypeResolver;

public class ViewLoaderReflectionUtils {
    public static Optional<Field> getViewModelField(Class<? extends View> viewType, Class<?> viewModelType) {
        List<Field> allViewModelFields = ViewLoaderReflectionUtils.getViewModelFields(viewType);
        if (allViewModelFields.isEmpty()) {
            return Optional.empty();
        }
        if (allViewModelFields.size() > 1) {
            throw new RuntimeException("The View <" + viewType + "> may only define one viewModel but there were <" + allViewModelFields.size() + "> viewModel fields with the @InjectViewModel annotation!");
        }
        Field field = allViewModelFields.get(0);
        if (!ViewModel.class.isAssignableFrom(field.getType())) {
            throw new RuntimeException("The View <" + viewType + "> has a field annotated with @InjectViewModel but the type of the field doesn't implement the 'ViewModel' interface!");
        }
        if (!field.getType().isAssignableFrom(viewModelType)) {
            throw new RuntimeException("The View <" + viewType + "> has a field annotated with @InjectViewModel but the type of the field doesn't match the generic ViewModel type of the View class. " + "The declared generic type is <" + viewModelType + "> but the actual type of the field is <" + field.getType() + ">.");
        }
        return Optional.of(field);
    }

    public static List<Field> getViewModelFields(Class<? extends View> viewType) {
        return ReflectionUtils.getFieldsFromClassHierarchy(viewType).stream().filter(field -> field.isAnnotationPresent(InjectViewModel.class)).collect(Collectors.toList());
    }

    public static <ViewType extends View<? extends ViewModelType>, ViewModelType extends ViewModel> ViewModelType getExistingViewModel(ViewType view) {
        Class viewModelType = TypeResolver.resolveRawArgument(View.class, view.getClass());
        Optional<Field> fieldOptional = ViewLoaderReflectionUtils.getViewModelField(view.getClass(), viewModelType);
        if (fieldOptional.isPresent()) {
            Field field = fieldOptional.get();
            return (ViewModelType)ReflectionUtils.accessField(field, () -> (ViewModel)field.get(view), "Can't get the viewModel of type <" + viewModelType + ">");
        }
        return null;
    }

    public static void injectViewModel(View view, ViewModel viewModel) {
        if (viewModel == null) {
            return;
        }
        Optional<Field> fieldOptional = ViewLoaderReflectionUtils.getViewModelField(view.getClass(), viewModel.getClass());
        if (fieldOptional.isPresent()) {
            Field field = fieldOptional.get();
            ReflectionUtils.accessField(field, () -> {
                Object existingViewModel = field.get(view);
                if (existingViewModel == null) {
                    field.set(view, viewModel);
                }
            }, "Can't inject ViewModel of type <" + viewModel.getClass() + "> into the view <" + view + ">");
        }
    }

    public static <V extends View<? extends VM>, VM extends ViewModel> Optional<VM> createAndInjectViewModel(V view) {
        Class viewModelType = TypeResolver.resolveRawArgument(View.class, view.getClass());
        if (viewModelType == ViewModel.class) {
            List<Field> viewModelFields = ViewLoaderReflectionUtils.getViewModelFields(view.getClass());
            if (!viewModelFields.isEmpty()) {
                throw new RuntimeException("The given view of type <" + view.getClass() + "> has no generic viewModel type declared but tries to inject a viewModel.");
            }
            return Optional.empty();
        }
        if (viewModelType == TypeResolver.Unknown.class) {
            return Optional.empty();
        }
        Optional<Field> fieldOptional = ViewLoaderReflectionUtils.getViewModelField(view.getClass(), viewModelType);
        if (fieldOptional.isPresent()) {
            Field field = fieldOptional.get();
            Object viewModel = ReflectionUtils.accessField(field, () -> {
                Object existingViewModel = field.get(view);
                if (existingViewModel != null) {
                    return existingViewModel;
                }
                Object newViewModel = DependencyInjector.getInstance().getInstanceOf(viewModelType);
                field.set(view, newViewModel);
                return newViewModel;
            }, "Can't inject ViewModel of type <" + viewModelType + "> into the view <" + view + ">");
            if (viewModel == null) {
                return Optional.empty();
            }
            try {
                return Optional.of((ViewModel)viewModel);
            }
            catch (ClassCastException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static <ViewType extends View<? extends ViewModelType>, ViewModelType extends ViewModel> ViewModelType createViewModel(ViewType view) {
        Class viewModelType = TypeResolver.resolveRawArgument(View.class, view.getClass());
        if (viewModelType == ViewModel.class) {
            return null;
        }
        if (TypeResolver.Unknown.class == viewModelType) {
            return null;
        }
        return (ViewModelType)((ViewModel)DependencyInjector.getInstance().getInstanceOf(viewModelType));
    }

    public static <ViewModelType extends ViewModel> void initializeViewModel(ViewModelType viewModel) {
        try {
            Method initMethod = viewModel.getClass().getMethod("initialize", new Class[0]);
            AccessController.doPrivileged(() -> {
                try {
                    return initMethod.invoke((Object)viewModel, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException("mvvmFX wasn't able to call the initialize method of ViewModel [" + viewModel + "].", e);
                }
            });
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

