/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.internal.viewloader;

import de.saxsys.mvvmfx.ViewModel;
import de.saxsys.mvvmfx.ViewTuple;
import de.saxsys.mvvmfx.internal.viewloader.DependencyInjector;
import de.saxsys.mvvmfx.internal.viewloader.ResourceBundleInjector;
import de.saxsys.mvvmfx.internal.viewloader.View;
import de.saxsys.mvvmfx.internal.viewloader.ViewLoaderReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.List;
import java.util.ResourceBundle;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaViewLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JavaViewLoader.class);
    private static final String NAMING_CONVENTION_RESOURCES_IDENTIFIER = "resources";
    private static final String NAMING_CONVENTION_INITIALIZE_IDENTIFIER = "initialize";

    public <ViewType extends View<? extends ViewModelType>, ViewModelType extends ViewModel> ViewTuple<ViewType, ViewModelType> loadJavaViewTuple(Class<? extends ViewType> viewType, ResourceBundle resourceBundle, ViewModelType existingViewModel) {
        DependencyInjector injectionFacade = DependencyInjector.getInstance();
        View view = (View)injectionFacade.getInstanceOf(viewType);
        if (!(view instanceof Parent)) {
            throw new IllegalArgumentException("Can not load java view! The view class has to extend from " + Parent.class.getName() + " or one of it's subclasses");
        }
        ViewModel viewModel = null;
        viewModel = existingViewModel == null ? (ViewModel)ViewLoaderReflectionUtils.createViewModel(view) : (ViewModel)existingViewModel;
        ResourceBundleInjector.injectResourceBundle(view, resourceBundle);
        if (viewModel == null) {
            List<Field> viewModelFields = ViewLoaderReflectionUtils.getViewModelFields(viewType);
            if (!viewModelFields.isEmpty()) {
                throw new RuntimeException("The given view of type <" + view.getClass() + "> has no generic viewModel type declared but tries to inject a viewModel.");
            }
        } else {
            ResourceBundleInjector.injectResourceBundle(viewModel, resourceBundle);
            ViewLoaderReflectionUtils.initializeViewModel(viewModel);
            ViewLoaderReflectionUtils.injectViewModel(view, viewModel);
        }
        if (view instanceof Initializable) {
            Initializable initializable = (Initializable)view;
            initializable.initialize(null, resourceBundle);
        } else {
            this.injectResourceBundle(view, resourceBundle);
            this.callInitialize(view);
        }
        return new ViewTuple<View, Object>(view, (Parent)view, viewModel);
    }

    <ViewModelType extends ViewModel> void callInitialize(View<? extends ViewModelType> view) {
        try {
            Method initializeMethod = view.getClass().getMethod(NAMING_CONVENTION_INITIALIZE_IDENTIFIER, new Class[0]);
            AccessController.doPrivileged(() -> {
                try {
                    return initializeMethod.invoke((Object)view, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    LOG.warn("The '{}' method of the view {} has thrown an exception!", (Object)NAMING_CONVENTION_INITIALIZE_IDENTIFIER, (Object)view);
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new RuntimeException(cause);
                }
                catch (IllegalAccessException e) {
                    LOG.warn("Can't invoke the '{}' method of the view {} because it is not accessible", (Object)NAMING_CONVENTION_INITIALIZE_IDENTIFIER, (Object)view);
                    return null;
                }
            });
        }
        catch (NoSuchMethodException e) {
            LOG.debug("There is no '{}' method declared at the view {}", (Object)NAMING_CONVENTION_INITIALIZE_IDENTIFIER, view);
        }
    }

    <ViewModelType extends ViewModel> void injectResourceBundle(View<? extends ViewModelType> view, ResourceBundle resourceBundle) {
        try {
            Field resourcesField = view.getClass().getField(NAMING_CONVENTION_RESOURCES_IDENTIFIER);
            if (resourcesField.getType().isAssignableFrom(ResourceBundle.class)) {
                resourcesField.set(view, resourceBundle);
            }
        }
        catch (NoSuchFieldException resourcesField) {
        }
        catch (IllegalAccessException e) {
            LOG.warn("Can't inject the ResourceBundle into the view {} because the field isn't accessible", view);
        }
    }
}

