/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.validation;

import de.saxsys.mvvmfx.utils.validation.Severity;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import java.util.Collection;
import java.util.Optional;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;

public class ValidationStatus {
    private ListProperty<ValidationMessage> messages = new SimpleListProperty(FXCollections.observableArrayList());
    private ObservableList<ValidationMessage> unmodifiableMessages = FXCollections.unmodifiableObservableList(this.messages);
    private ObservableList<ValidationMessage> errorMessages = FXCollections.unmodifiableObservableList((ObservableList)new FilteredList(this.messages, message -> message.getSeverity().equals((Object)Severity.ERROR)));
    private ObservableList<ValidationMessage> warningMessages = FXCollections.unmodifiableObservableList((ObservableList)new FilteredList(this.messages, message -> message.getSeverity().equals((Object)Severity.WARNING)));

    void addMessage(ValidationMessage message) {
        this.messages.add((Object)message);
    }

    void addMessage(Collection<ValidationMessage> messages) {
        this.messages.addAll(messages);
    }

    void removeMessage(ValidationMessage message) {
        this.messages.remove((Object)message);
    }

    void removeMessage(Collection<? extends ValidationMessage> messages) {
        this.messages.removeAll(messages);
    }

    void clearMessages() {
        this.messages.clear();
    }

    public ObservableList<ValidationMessage> getMessages() {
        return this.unmodifiableMessages;
    }

    public ObservableList<ValidationMessage> getErrorMessages() {
        return this.errorMessages;
    }

    public ObservableList<ValidationMessage> getWarningMessages() {
        return this.warningMessages;
    }

    public ReadOnlyBooleanProperty validProperty() {
        return this.messages.emptyProperty();
    }

    public boolean isValid() {
        return this.validProperty().get();
    }

    public Optional<ValidationMessage> getHighestMessage() {
        if (!this.errorMessages.isEmpty()) {
            return Optional.of(this.errorMessages.get(0));
        }
        if (!this.warningMessages.isEmpty()) {
            return Optional.of(this.warningMessages.get(0));
        }
        return Optional.empty();
    }
}

