/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.validation;

import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;

class CompositeValidationResult
extends ValidationStatus {
    private ListProperty<ValidationStatus> subResults = new SimpleListProperty(FXCollections.observableArrayList());
    private Map<ValidationStatus, ListChangeListener<ValidationMessage>> changeListeners = new HashMap<ValidationStatus, ListChangeListener<ValidationMessage>>();

    public CompositeValidationResult() {
        this.subResults.addListener(c -> {
            while (c.next()) {
                c.getAddedSubList().forEach(result -> {
                    this.addMessage((Collection<ValidationMessage>)result.getMessages());
                    ListChangeListener changeListener = change -> {
                        while (change.next()) {
                            change.getAddedSubList().forEach(this::addMessage);
                            change.getRemoved().forEach(this::removeMessage);
                        }
                    };
                    result.getMessages().addListener(changeListener);
                    this.changeListeners.put((ValidationStatus)result, (ListChangeListener<ValidationMessage>)changeListener);
                });
                c.getRemoved().forEach(result -> {
                    this.removeMessage((Collection<? extends ValidationMessage>)result.getMessages());
                    result.getMessages().removeListener(this.changeListeners.get(result));
                });
            }
        });
    }

    void addResults(ValidationStatus ... results) {
        this.subResults.addAll((Object[])results);
    }

    void addResults(List<ValidationStatus> results) {
        this.subResults.addAll(results);
    }

    void removeResults(ValidationStatus ... results) {
        this.subResults.removeAll((Object[])results);
    }

    void removeResults(List<ValidationStatus> results) {
        this.subResults.removeAll(results);
    }
}

