/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.mapping;

import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.BooleanGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.BooleanPropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.BooleanSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.DoubleGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.DoublePropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.DoubleSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.FloatGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.FloatPropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.FloatSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.IntGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.IntPropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.IntSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.LongGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.LongPropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.LongSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.ObjectGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.ObjectPropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.ObjectSetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.StringGetter;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.StringPropertyAccessor;
import de.saxsys.mvvmfx.utils.mapping.accessorfunctions.StringSetter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class ModelWrapper<M> {
    private ReadOnlyBooleanWrapper dirtyFlag = new ReadOnlyBooleanWrapper();
    private ReadOnlyBooleanWrapper diffFlag = new ReadOnlyBooleanWrapper();
    private Set<PropertyField<?, M, ?>> fields = new HashSet();
    private Map<String, PropertyField<?, M, ?>> identifiedFields = new HashMap();
    private M model;

    public ModelWrapper(M model) {
        this.set(model);
        this.reload();
    }

    public ModelWrapper() {
    }

    public void set(M model) {
        this.model = model;
    }

    public M get() {
        return this.model;
    }

    public void reset() {
        this.fields.forEach(field -> field.resetToDefault());
        this.calculateDifferenceFlag();
    }

    public void commit() {
        if (this.model != null) {
            this.fields.forEach(field -> field.commit(this.model));
            this.dirtyFlag.set(false);
            this.calculateDifferenceFlag();
        }
    }

    public void reload() {
        if (this.model != null) {
            this.fields.forEach(field -> field.reload(this.model));
            this.dirtyFlag.set(false);
            this.calculateDifferenceFlag();
        }
    }

    private void propertyWasChanged() {
        this.dirtyFlag.set(true);
        this.calculateDifferenceFlag();
    }

    private void calculateDifferenceFlag() {
        if (this.model != null) {
            Optional<PropertyField> optional = this.fields.stream().filter(field -> field.isDifferent(this.model)).findAny();
            this.diffFlag.set(optional.isPresent());
        }
    }

    public StringProperty field(StringGetter<M> getter, StringSetter<M> setter) {
        return (StringProperty)this.add(new BeanPropertyField(getter, setter, SimpleStringProperty::new));
    }

    public StringProperty field(StringGetter<M> getter, StringSetter<M> setter, String defaultValue) {
        return (StringProperty)this.add(new BeanPropertyField<String, SimpleStringProperty>(getter, setter, defaultValue, SimpleStringProperty::new));
    }

    public StringProperty field(StringPropertyAccessor<M> accessor) {
        return (StringProperty)this.add(new FxPropertyField(accessor::apply, SimpleStringProperty::new));
    }

    public StringProperty field(StringPropertyAccessor<M> accessor, String defaultValue) {
        return (StringProperty)this.add(new FxPropertyField(accessor::apply, SimpleStringProperty::new));
    }

    public StringProperty field(String identifier, StringGetter<M> getter, StringSetter<M> setter) {
        return (StringProperty)this.addIdentified(identifier, new BeanPropertyField(getter, setter, SimpleStringProperty::new));
    }

    public StringProperty field(String identifier, StringGetter<M> getter, StringSetter<M> setter, String defaultValue) {
        return (StringProperty)this.addIdentified(identifier, new BeanPropertyField<String, SimpleStringProperty>(getter, setter, defaultValue, SimpleStringProperty::new));
    }

    public StringProperty field(String identifier, StringPropertyAccessor<M> accessor) {
        return (StringProperty)this.addIdentified(identifier, new FxPropertyField(accessor::apply, SimpleStringProperty::new));
    }

    public StringProperty field(String identifier, StringPropertyAccessor<M> accessor, String defaultValue) {
        return (StringProperty)this.addIdentified(identifier, new FxPropertyField(accessor::apply, defaultValue, SimpleStringProperty::new));
    }

    public BooleanProperty field(BooleanGetter<M> getter, BooleanSetter<M> setter) {
        return (BooleanProperty)this.add(new BeanPropertyField(getter, setter, SimpleBooleanProperty::new));
    }

    public BooleanProperty field(BooleanGetter<M> getter, BooleanSetter<M> setter, boolean defaultValue) {
        return (BooleanProperty)this.add(new BeanPropertyField<Boolean, SimpleBooleanProperty>(getter, setter, defaultValue, SimpleBooleanProperty::new));
    }

    public BooleanProperty field(BooleanPropertyAccessor<M> accessor) {
        return (BooleanProperty)this.add(new FxPropertyField(accessor, SimpleBooleanProperty::new));
    }

    public BooleanProperty field(BooleanPropertyAccessor<M> accessor, boolean defaultValue) {
        return (BooleanProperty)this.add(new FxPropertyField(accessor, defaultValue, SimpleBooleanProperty::new));
    }

    public BooleanProperty field(String identifier, BooleanGetter<M> getter, BooleanSetter<M> setter) {
        return (BooleanProperty)this.addIdentified(identifier, new BeanPropertyField(getter, setter, SimpleBooleanProperty::new));
    }

    public BooleanProperty field(String identifier, BooleanGetter<M> getter, BooleanSetter<M> setter, boolean defaultValue) {
        return (BooleanProperty)this.addIdentified(identifier, new BeanPropertyField<Boolean, SimpleBooleanProperty>(getter, setter, defaultValue, SimpleBooleanProperty::new));
    }

    public BooleanProperty field(String identifier, BooleanPropertyAccessor<M> accessor) {
        return (BooleanProperty)this.addIdentified(identifier, new FxPropertyField(accessor, SimpleBooleanProperty::new));
    }

    public BooleanProperty field(String identifier, BooleanPropertyAccessor<M> accessor, boolean defaultValue) {
        return (BooleanProperty)this.addIdentified(identifier, new FxPropertyField(accessor, defaultValue, SimpleBooleanProperty::new));
    }

    public DoubleProperty field(DoubleGetter<M> getter, DoubleSetter<M> setter) {
        return (DoubleProperty)this.add(new BeanPropertyField<Number, SimpleDoubleProperty>(getter::apply, (m, number) -> setter.accept(m, number.doubleValue()), SimpleDoubleProperty::new));
    }

    public DoubleProperty field(DoubleGetter<M> getter, DoubleSetter<M> setter, double defaultValue) {
        return (DoubleProperty)this.add(new BeanPropertyField<Double, SimpleDoubleProperty>(getter::apply, (m, number) -> setter.accept(m, number.doubleValue()), defaultValue, SimpleDoubleProperty::new));
    }

    public DoubleProperty field(DoublePropertyAccessor<M> accessor) {
        return (DoubleProperty)this.add(new FxPropertyField(accessor::apply, SimpleDoubleProperty::new));
    }

    public DoubleProperty field(DoublePropertyAccessor<M> accessor, double defaultValue) {
        return (DoubleProperty)this.add(new FxPropertyField(accessor::apply, defaultValue, SimpleDoubleProperty::new));
    }

    public DoubleProperty field(String identifier, DoubleGetter<M> getter, DoubleSetter<M> setter) {
        return (DoubleProperty)this.addIdentified(identifier, new BeanPropertyField<Number, SimpleDoubleProperty>(getter::apply, (m, number) -> setter.accept(m, number.doubleValue()), SimpleDoubleProperty::new));
    }

    public DoubleProperty field(String identifier, DoubleGetter<M> getter, DoubleSetter<M> setter, double defaultValue) {
        return (DoubleProperty)this.addIdentified(identifier, new BeanPropertyField<Double, SimpleDoubleProperty>(getter::apply, (m, number) -> setter.accept(m, number.doubleValue()), defaultValue, SimpleDoubleProperty::new));
    }

    public DoubleProperty field(String identifier, DoublePropertyAccessor<M> accessor) {
        return (DoubleProperty)this.addIdentified(identifier, new FxPropertyField(accessor::apply, SimpleDoubleProperty::new));
    }

    public DoubleProperty field(String identifier, DoublePropertyAccessor<M> accessor, double defaultValue) {
        return (DoubleProperty)this.addIdentified(identifier, new FxPropertyField(accessor::apply, defaultValue, SimpleDoubleProperty::new));
    }

    public FloatProperty field(FloatGetter<M> getter, FloatSetter<M> setter) {
        return (FloatProperty)this.add(new BeanPropertyField<Number, SimpleFloatProperty>(getter::apply, (m, number) -> setter.accept(m, Float.valueOf(number.floatValue())), SimpleFloatProperty::new));
    }

    public FloatProperty field(FloatGetter<M> getter, FloatSetter<M> setter, float defaultValue) {
        return (FloatProperty)this.add(new BeanPropertyField<Float, SimpleFloatProperty>(getter::apply, (m, number) -> setter.accept(m, Float.valueOf(number.floatValue())), Float.valueOf(defaultValue), SimpleFloatProperty::new));
    }

    public FloatProperty field(FloatPropertyAccessor<M> accessor) {
        return (FloatProperty)this.add(new FxPropertyField(accessor::apply, SimpleFloatProperty::new));
    }

    public FloatProperty field(FloatPropertyAccessor<M> accessor, float defaultValue) {
        return (FloatProperty)this.add(new FxPropertyField(accessor::apply, Float.valueOf(defaultValue), SimpleFloatProperty::new));
    }

    public FloatProperty field(String identifier, FloatGetter<M> getter, FloatSetter<M> setter) {
        return (FloatProperty)this.addIdentified(identifier, new BeanPropertyField<Number, SimpleFloatProperty>(getter::apply, (m, number) -> setter.accept(m, Float.valueOf(number.floatValue())), SimpleFloatProperty::new));
    }

    public FloatProperty field(String identifier, FloatGetter<M> getter, FloatSetter<M> setter, float defaultValue) {
        return (FloatProperty)this.addIdentified(identifier, new BeanPropertyField<Float, SimpleFloatProperty>(getter::apply, (m, number) -> setter.accept(m, Float.valueOf(number.floatValue())), Float.valueOf(defaultValue), SimpleFloatProperty::new));
    }

    public FloatProperty field(String identifier, FloatPropertyAccessor<M> accessor) {
        return (FloatProperty)this.addIdentified(identifier, new FxPropertyField(accessor::apply, SimpleFloatProperty::new));
    }

    public FloatProperty field(String identifier, FloatPropertyAccessor<M> accessor, float defaultValue) {
        return (FloatProperty)this.addIdentified(identifier, new FxPropertyField(accessor::apply, Float.valueOf(defaultValue), SimpleFloatProperty::new));
    }

    public IntegerProperty field(IntGetter<M> getter, IntSetter<M> setter) {
        return (IntegerProperty)this.add(new BeanPropertyField<Number, SimpleIntegerProperty>(getter::apply, (m, number) -> setter.accept(m, number.intValue()), SimpleIntegerProperty::new));
    }

    public IntegerProperty field(IntGetter<M> getter, IntSetter<M> setter, int defaultValue) {
        return (IntegerProperty)this.add(new BeanPropertyField<Integer, SimpleIntegerProperty>(getter::apply, (m, number) -> setter.accept(m, number.intValue()), defaultValue, SimpleIntegerProperty::new));
    }

    public IntegerProperty field(IntPropertyAccessor<M> accessor) {
        return (IntegerProperty)this.add(new FxPropertyField(accessor::apply, SimpleIntegerProperty::new));
    }

    public IntegerProperty field(IntPropertyAccessor<M> accessor, int defaultValue) {
        return (IntegerProperty)this.add(new FxPropertyField(accessor::apply, defaultValue, SimpleIntegerProperty::new));
    }

    public IntegerProperty field(String identifier, IntGetter<M> getter, IntSetter<M> setter) {
        return (IntegerProperty)this.addIdentified(identifier, new BeanPropertyField<Number, SimpleIntegerProperty>(getter::apply, (m, number) -> setter.accept(m, number.intValue()), SimpleIntegerProperty::new));
    }

    public IntegerProperty field(String identifier, IntGetter<M> getter, IntSetter<M> setter, int defaultValue) {
        return (IntegerProperty)this.addIdentified(identifier, new BeanPropertyField<Integer, SimpleIntegerProperty>(getter::apply, (m, number) -> setter.accept(m, number.intValue()), defaultValue, SimpleIntegerProperty::new));
    }

    public IntegerProperty field(String identifier, IntPropertyAccessor<M> accessor) {
        return (IntegerProperty)this.addIdentified(identifier, new FxPropertyField(accessor::apply, SimpleIntegerProperty::new));
    }

    public IntegerProperty field(String identifier, IntPropertyAccessor<M> accessor, int defaultValue) {
        return (IntegerProperty)this.addIdentified(identifier, new FxPropertyField(accessor::apply, defaultValue, SimpleIntegerProperty::new));
    }

    public LongProperty field(LongGetter<M> getter, LongSetter<M> setter) {
        return (LongProperty)this.add(new BeanPropertyField<Number, SimpleLongProperty>(getter::apply, (m, number) -> setter.accept(m, number.longValue()), SimpleLongProperty::new));
    }

    public LongProperty field(LongGetter<M> getter, LongSetter<M> setter, long defaultValue) {
        return (LongProperty)this.add(new BeanPropertyField<Long, SimpleLongProperty>(getter::apply, (m, number) -> setter.accept(m, number.longValue()), defaultValue, SimpleLongProperty::new));
    }

    public LongProperty field(LongPropertyAccessor<M> accessor) {
        return (LongProperty)this.add(new FxPropertyField(accessor::apply, SimpleLongProperty::new));
    }

    public LongProperty field(LongPropertyAccessor<M> accessor, long defaultValue) {
        return (LongProperty)this.add(new FxPropertyField(accessor::apply, defaultValue, SimpleLongProperty::new));
    }

    public LongProperty field(String identifier, LongGetter<M> getter, LongSetter<M> setter) {
        return (LongProperty)this.addIdentified(identifier, new BeanPropertyField<Number, SimpleLongProperty>(getter::apply, (m, number) -> setter.accept(m, number.longValue()), SimpleLongProperty::new));
    }

    public LongProperty field(String identifier, LongGetter<M> getter, LongSetter<M> setter, long defaultValue) {
        return (LongProperty)this.addIdentified(identifier, new BeanPropertyField<Long, SimpleLongProperty>(getter::apply, (m, number) -> setter.accept(m, number.longValue()), defaultValue, SimpleLongProperty::new));
    }

    public LongProperty field(String identifier, LongPropertyAccessor<M> accessor) {
        return (LongProperty)this.addIdentified(identifier, new FxPropertyField(accessor::apply, SimpleLongProperty::new));
    }

    public LongProperty field(String identifier, LongPropertyAccessor<M> accessor, long defaultValue) {
        return (LongProperty)this.addIdentified(identifier, new FxPropertyField(accessor::apply, defaultValue, SimpleLongProperty::new));
    }

    public <T> ObjectProperty<T> field(ObjectGetter<M, T> getter, ObjectSetter<M, T> setter) {
        return (ObjectProperty)this.add(new BeanPropertyField<T, SimpleObjectProperty>(getter, setter, SimpleObjectProperty::new));
    }

    public <T> ObjectProperty<T> field(ObjectGetter<M, T> getter, ObjectSetter<M, T> setter, T defaultValue) {
        return (ObjectProperty)this.add(new BeanPropertyField<T, SimpleObjectProperty>(getter, setter, defaultValue, SimpleObjectProperty::new));
    }

    public <T> ObjectProperty<T> field(ObjectPropertyAccessor<M, T> accessor) {
        return (ObjectProperty)this.add(new FxPropertyField(accessor::apply, SimpleObjectProperty::new));
    }

    public <T> ObjectProperty<T> field(ObjectPropertyAccessor<M, T> accessor, T defaultValue) {
        return (ObjectProperty)this.add(new FxPropertyField(accessor::apply, defaultValue, SimpleObjectProperty::new));
    }

    public <T> ObjectProperty<T> field(String identifier, ObjectGetter<M, T> getter, ObjectSetter<M, T> setter) {
        return (ObjectProperty)this.addIdentified(identifier, new BeanPropertyField<T, SimpleObjectProperty>(getter, setter, SimpleObjectProperty::new));
    }

    public <T> ObjectProperty<T> field(String identifier, ObjectGetter<M, T> getter, ObjectSetter<M, T> setter, T defaultValue) {
        return (ObjectProperty)this.addIdentified(identifier, new BeanPropertyField<T, SimpleObjectProperty>(getter, setter, defaultValue, SimpleObjectProperty::new));
    }

    public <T> ObjectProperty<T> field(String identifier, ObjectPropertyAccessor<M, T> accessor) {
        return (ObjectProperty)this.addIdentified(identifier, new FxPropertyField(accessor::apply, SimpleObjectProperty::new));
    }

    public <T> ObjectProperty<T> field(String identifier, ObjectPropertyAccessor<M, T> accessor, T defaultValue) {
        return (ObjectProperty)this.addIdentified(identifier, new FxPropertyField(accessor::apply, defaultValue, SimpleObjectProperty::new));
    }

    private <T, R extends Property<T>> R add(PropertyField<T, M, R> field) {
        this.fields.add(field);
        if (this.model != null) {
            field.reload(this.model);
        }
        return field.getProperty();
    }

    private <T, R extends Property<T>> R addIdentified(String fieldName, PropertyField<T, M, R> field) {
        if (this.identifiedFields.containsKey(fieldName)) {
            Object property = this.identifiedFields.get(fieldName).getProperty();
            return (R)property;
        }
        this.identifiedFields.put(fieldName, field);
        return this.add(field);
    }

    public ReadOnlyBooleanProperty differentProperty() {
        return this.diffFlag.getReadOnlyProperty();
    }

    public boolean isDifferent() {
        return this.diffFlag.get();
    }

    public ReadOnlyBooleanProperty dirtyProperty() {
        return this.dirtyFlag.getReadOnlyProperty();
    }

    public boolean isDirty() {
        return this.dirtyFlag.get();
    }

    private class BeanPropertyField<T, R extends Property<T>>
    implements PropertyField<T, M, R> {
        private final R targetProperty;
        private final T defaultValue;
        private final Function<M, T> getter;
        private final BiConsumer<M, T> setter;

        public BeanPropertyField(Function<M, T> getter, BiConsumer<M, T> setter, Supplier<R> propertySupplier) {
            this(getter, setter, null, propertySupplier);
        }

        public BeanPropertyField(Function<M, T> getter, BiConsumer<M, T> setter, T defaultValue, Supplier<R> propertySupplier) {
            this.defaultValue = defaultValue;
            this.getter = getter;
            this.setter = setter;
            this.targetProperty = (Property)propertySupplier.get();
            this.targetProperty.addListener((observable, oldValue, newValue) -> ModelWrapper.this.propertyWasChanged());
        }

        @Override
        public void commit(M wrappedObject) {
            this.setter.accept(wrappedObject, this.targetProperty.getValue());
        }

        @Override
        public void reload(M wrappedObject) {
            this.targetProperty.setValue(this.getter.apply(wrappedObject));
        }

        @Override
        public void resetToDefault() {
            this.targetProperty.setValue(this.defaultValue);
        }

        @Override
        public R getProperty() {
            return this.targetProperty;
        }

        @Override
        public boolean isDifferent(M wrappedObject) {
            Object wrapperValue;
            T modelValue = this.getter.apply(wrappedObject);
            return !Objects.equals(modelValue, wrapperValue = this.targetProperty.getValue());
        }
    }

    private class FxPropertyField<T, R extends Property<T>>
    implements PropertyField<T, M, R> {
        private final T defaultValue;
        private final Function<M, Property<T>> accessor;
        private final R targetProperty;

        public FxPropertyField(Function<M, Property<T>> accessor, Supplier<Property<T>> propertySupplier) {
            this(accessor, null, propertySupplier);
        }

        public FxPropertyField(Function<M, Property<T>> accessor, T defaultValue, Supplier<Property<T>> propertySupplier) {
            this.accessor = accessor;
            this.defaultValue = defaultValue;
            this.targetProperty = propertySupplier.get();
            this.targetProperty.addListener((observable, oldValue, newValue) -> ModelWrapper.this.propertyWasChanged());
        }

        @Override
        public void commit(M wrappedObject) {
            this.accessor.apply(wrappedObject).setValue(this.targetProperty.getValue());
        }

        @Override
        public void reload(M wrappedObject) {
            this.targetProperty.setValue(this.accessor.apply(wrappedObject).getValue());
        }

        @Override
        public void resetToDefault() {
            this.targetProperty.setValue(this.defaultValue);
        }

        @Override
        public R getProperty() {
            return this.targetProperty;
        }

        @Override
        public boolean isDifferent(M wrappedObject) {
            Object wrapperValue;
            Object modelValue = this.accessor.apply(wrappedObject).getValue();
            return !Objects.equals(modelValue, wrapperValue = this.targetProperty.getValue());
        }
    }

    private static interface PropertyField<T, M, R extends Property<T>> {
        public void commit(M var1);

        public void reload(M var1);

        public void resetToDefault();

        public R getProperty();

        public boolean isDifferent(M var1);
    }
}

