/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.internal.viewloader;

import de.saxsys.mvvmfx.ViewModel;
import de.saxsys.mvvmfx.ViewTuple;
import de.saxsys.mvvmfx.internal.viewloader.DependencyInjector;
import de.saxsys.mvvmfx.internal.viewloader.ResourceBundleInjector;
import de.saxsys.mvvmfx.internal.viewloader.View;
import de.saxsys.mvvmfx.internal.viewloader.ViewLoaderReflectionUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FxmlViewLoader {
    private static final Logger LOG = LoggerFactory.getLogger(FxmlViewLoader.class);

    public <ViewType extends View<? extends ViewModelType>, ViewModelType extends ViewModel> ViewTuple<ViewType, ViewModelType> loadFxmlViewTuple(Class<? extends ViewType> viewType, ResourceBundle resourceBundle, ViewType codeBehind, Object root, ViewModelType viewModel) {
        String pathToFXML = this.createFxmlPath(viewType);
        return this.loadFxmlViewTuple(pathToFXML, resourceBundle, codeBehind, root, viewModel);
    }

    private String createFxmlPath(Class<?> viewType) {
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append("/");
        if (viewType.getPackage() != null) {
            pathBuilder.append(viewType.getPackage().getName().replaceAll("\\.", "/"));
            pathBuilder.append("/");
        }
        pathBuilder.append(viewType.getSimpleName());
        pathBuilder.append(".fxml");
        return pathBuilder.toString();
    }

    public <ViewType extends View<? extends ViewModelType>, ViewModelType extends ViewModel> ViewTuple<ViewType, ViewModelType> loadFxmlViewTuple(String resource, ResourceBundle resourceBundle, ViewType codeBehind, Object root, ViewModelType viewModel) {
        try {
            FXMLLoader loader = this.createFxmlLoader(resource, resourceBundle, codeBehind, root, viewModel);
            loader.load();
            View loadedController = (View)loader.getController();
            Parent loadedRoot = (Parent)loader.getRoot();
            if (loadedController == null) {
                throw new IOException("Could not load the controller for the View " + resource + " maybe your missed the fx:controller in your fxml?");
            }
            Object loadedViewModel = ViewLoaderReflectionUtils.getExistingViewModel(loadedController);
            if (loadedViewModel == null) {
                loadedViewModel = ViewLoaderReflectionUtils.createViewModel(loadedController);
            }
            return new ViewTuple(loadedController, loadedRoot, loadedViewModel);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private FXMLLoader createFxmlLoader(String resource, ResourceBundle resourceBundle, View codeBehind, Object root, ViewModel viewModel) throws IOException {
        URL location = FxmlViewLoader.class.getResource(resource);
        if (location == null) {
            throw new IOException("Error loading FXML - can't load from given resourcepath: " + resource);
        }
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setRoot(root);
        fxmlLoader.setResources(resourceBundle);
        fxmlLoader.setLocation(location);
        if (viewModel != null && codeBehind == null) {
            fxmlLoader.setControllerFactory((Callback)new ControllerFactoryForCustomViewModel(viewModel, resourceBundle));
        } else {
            fxmlLoader.setControllerFactory((Callback)new DefaultControllerFactory(resourceBundle));
        }
        if (codeBehind != null) {
            fxmlLoader.setController((Object)codeBehind);
            if (viewModel == null) {
                FxmlViewLoader.handleInjection(codeBehind, resourceBundle);
            } else {
                FxmlViewLoader.handleInjection(codeBehind, resourceBundle, viewModel);
            }
        }
        return fxmlLoader;
    }

    private static void handleInjection(View codeBehind, ResourceBundle resourceBundle) {
        Object viewModel;
        ResourceBundleInjector.injectResourceBundle(codeBehind, resourceBundle);
        Optional viewModelOptional = ViewLoaderReflectionUtils.createAndInjectViewModel(codeBehind);
        if (viewModelOptional.isPresent() && (viewModel = viewModelOptional.get()) instanceof ViewModel) {
            ResourceBundleInjector.injectResourceBundle(viewModel, resourceBundle);
            ViewLoaderReflectionUtils.initializeViewModel((ViewModel)viewModel);
        }
    }

    private static void handleInjection(View codeBehind, ResourceBundle resourceBundle, ViewModel viewModel) {
        ResourceBundleInjector.injectResourceBundle(codeBehind, resourceBundle);
        if (viewModel != null) {
            ResourceBundleInjector.injectResourceBundle(viewModel, resourceBundle);
            ViewLoaderReflectionUtils.injectViewModel(codeBehind, viewModel);
        }
    }

    private static class ControllerFactoryForCustomViewModel
    implements Callback<Class<?>, Object> {
        private boolean customViewModelInjected = false;
        private ViewModel customViewModel;
        private ResourceBundle resourceBundle;

        public ControllerFactoryForCustomViewModel(ViewModel customViewModel, ResourceBundle resourceBundle) {
            this.customViewModel = customViewModel;
            this.resourceBundle = resourceBundle;
        }

        public Object call(Class<?> type) {
            Object controller = DependencyInjector.getInstance().getInstanceOf(type);
            if (controller instanceof View) {
                View codeBehind = (View)controller;
                if (!this.customViewModelInjected) {
                    ResourceBundleInjector.injectResourceBundle(this.customViewModel, this.resourceBundle);
                    ResourceBundleInjector.injectResourceBundle(codeBehind, this.resourceBundle);
                    ViewLoaderReflectionUtils.injectViewModel(codeBehind, this.customViewModel);
                    this.customViewModelInjected = true;
                    return codeBehind;
                }
                FxmlViewLoader.handleInjection(codeBehind, this.resourceBundle);
            }
            return controller;
        }
    }

    private static class DefaultControllerFactory
    implements Callback<Class<?>, Object> {
        private ResourceBundle resourceBundle;

        public DefaultControllerFactory(ResourceBundle resourceBundle) {
            this.resourceBundle = resourceBundle;
        }

        public Object call(Class<?> type) {
            Object controller = DependencyInjector.getInstance().getInstanceOf(type);
            if (controller instanceof View) {
                View codeBehind = (View)controller;
                FxmlViewLoader.handleInjection(codeBehind, this.resourceBundle);
            }
            return controller;
        }
    }
}

