/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.notifications;

import de.saxsys.mvvmfx.ViewModel;
import de.saxsys.mvvmfx.utils.notifications.NotificationCenter;
import de.saxsys.mvvmfx.utils.notifications.NotificationObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultNotificationCenter
implements NotificationCenter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNotificationCenter.class);
    private final ObserverMap globalObservers = new ObserverMap();
    private final ViewModelObservers viewModelObservers = new ViewModelObservers();

    DefaultNotificationCenter() {
    }

    @Override
    public void subscribe(String messageName, NotificationObserver observer) {
        this.addObserver(messageName, observer, this.globalObservers);
    }

    @Override
    public void unsubscribe(String messageName, NotificationObserver observer) {
        this.removeObserversForMessageName(messageName, observer, this.globalObservers);
    }

    @Override
    public void unsubscribe(NotificationObserver observer) {
        this.removeObserverFromObserverMap(observer, this.globalObservers);
    }

    @Override
    public void publish(String messageName, Object ... payload) {
        this.publish(messageName, payload, this.globalObservers);
    }

    @Override
    public void publish(ViewModel viewModel, String messageName, Object[] payload) {
        ObserverMap observerMap = (ObserverMap)this.viewModelObservers.get(viewModel);
        if (observerMap != null) {
            this.publish(messageName, payload, observerMap);
        }
    }

    @Override
    public void subscribe(ViewModel view, String messageName, NotificationObserver observer) {
        ObserverMap observerMap = (ObserverMap)this.viewModelObservers.get(view);
        if (observerMap == null) {
            observerMap = new ObserverMap();
            this.viewModelObservers.put(view, observerMap);
        }
        this.addObserver(messageName, observer, observerMap);
    }

    @Override
    public void unsubscribe(ViewModel view, String messageName, NotificationObserver observer) {
        ObserverMap observerMap = (ObserverMap)this.viewModelObservers.get(view);
        if (observerMap != null) {
            this.removeObserversForMessageName(messageName, observer, observerMap);
        }
    }

    @Override
    public void unsubscribe(ViewModel viewModel, NotificationObserver observer) {
        ObserverMap observerMap = (ObserverMap)this.viewModelObservers.get(viewModel);
        this.removeObserverFromObserverMap(observer, observerMap);
    }

    private void publish(String messageName, Object[] payload, ObserverMap observerMap) {
        Collection notificationReceivers = (Collection)observerMap.get(messageName);
        if (notificationReceivers != null) {
            for (NotificationObserver observer : notificationReceivers) {
                observer.receivedNotification(messageName, payload);
            }
        }
    }

    private void addObserver(String messageName, NotificationObserver observer, ObserverMap observerMap) {
        List observers = (List)observerMap.get(messageName);
        if (observers == null) {
            observerMap.put(messageName, new ArrayList());
        }
        if ((observers = (List)observerMap.get(messageName)).contains(observer)) {
            LOG.warn("Subscribe the observer [" + observer + "] for the message [" + messageName + "], but the same observer was already added for this message in the past.");
        }
        observers.add(observer);
    }

    private void removeObserverFromObserverMap(NotificationObserver observer, ObserverMap observerMap) {
        for (String key : observerMap.keySet()) {
            List observers = (List)observerMap.get(key);
            List observersToBeRemoved = observers.stream().filter(actualObserver -> actualObserver.equals(observer)).collect(Collectors.toList());
            observers.removeAll(observersToBeRemoved);
        }
    }

    private void removeObserversForMessageName(String messageName, NotificationObserver observer, ObserverMap observerMap) {
        List observers = (List)observerMap.get(messageName);
        observers.remove(observer);
        if (observers.size() == 0) {
            observerMap.remove(messageName);
        }
    }

    private class ViewModelObservers
    extends HashMap<ViewModel, ObserverMap> {
        private ViewModelObservers() {
        }
    }

    private class ObserverMap
    extends HashMap<String, List<NotificationObserver>> {
        private ObserverMap() {
        }
    }
}

