/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.internal.viewloader;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class ReflectionUtils {
    public static List<Field> getFieldsWithAnnotation(Object target, Class<? extends Annotation> annotationType) {
        return Arrays.stream(target.getClass().getDeclaredFields()).filter(field -> field.isAnnotationPresent(annotationType)).collect(Collectors.toList());
    }

    public static <T> T accessField(Field field, Callable<T> callable, String errorMessage) {
        if (callable == null) {
            return null;
        }
        return (T)AccessController.doPrivileged(() -> {
            boolean wasAccessible = field.isAccessible();
            try {
                field.setAccessible(true);
                Object v = callable.call();
                return v;
            }
            catch (Exception exception) {
                throw new IllegalStateException(errorMessage, exception);
            }
            finally {
                field.setAccessible(wasAccessible);
            }
        });
    }

    public static void setField(Field field, Object target, Object value) {
        ReflectionUtils.accessField(field, () -> field.set(target, value), "Cannot set the field [" + field.getName() + "] of instance [" + target + "] to value [" + value + "]");
    }

    public static void accessField(Field field, SideEffect sideEffect, String errorMessage) {
        if (sideEffect == null) {
            return;
        }
        AccessController.doPrivileged(() -> {
            boolean wasAccessible = field.isAccessible();
            try {
                field.setAccessible(true);
                sideEffect.call();
            }
            catch (Exception exception) {
                throw new IllegalStateException(errorMessage, exception);
            }
            finally {
                field.setAccessible(wasAccessible);
            }
            return null;
        });
    }

    @FunctionalInterface
    public static interface SideEffect {
        public void call() throws Exception;
    }
}

