/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.notifications;

import de.saxsys.mvvmfx.utils.notifications.NotificationCenter;
import de.saxsys.mvvmfx.utils.notifications.NotificationObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DefaultNotificationCenter
implements NotificationCenter {
    private final Map<String, List<NotificationObserver>> observersForName = new HashMap<String, List<NotificationObserver>>();

    DefaultNotificationCenter() {
    }

    @Override
    public void subscribe(String messageName, NotificationObserver observer) {
        List<NotificationObserver> observers = this.observersForName.get(messageName);
        if (observers == null) {
            this.observersForName.put(messageName, new ArrayList());
        }
        observers = this.observersForName.get(messageName);
        observers.add(observer);
    }

    @Override
    public void unsubscribe(String messageName, NotificationObserver observer) {
        List<NotificationObserver> observers = this.observersForName.get(messageName);
        observers.remove(observer);
        if (observers.size() == 0) {
            this.observersForName.remove(messageName);
        }
    }

    @Override
    public void unsubscribe(NotificationObserver observer) {
        block0: for (String key : this.observersForName.keySet()) {
            for (NotificationObserver actualObserver : this.observersForName.get(key)) {
                if (actualObserver != observer) continue;
                this.observersForName.remove(key);
                continue block0;
            }
        }
    }

    @Override
    public void publish(String messageName, Object ... payload) {
        Collection notificationReceivers = this.observersForName.get(messageName);
        if (notificationReceivers != null) {
            for (NotificationObserver observer : notificationReceivers) {
                observer.receivedNotification(messageName, payload);
            }
        }
    }
}

