/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.mapping;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;

public class ModelWrapper<M> {
    private Set<PropertyField<?, M>> fields = new HashSet();
    private Map<String, PropertyField<?, M>> identifiedFields = new HashMap();
    private M model;

    public ModelWrapper(M model) {
        this.set(model);
        this.reload();
    }

    public ModelWrapper() {
    }

    public void set(M model) {
        this.model = model;
    }

    public M get() {
        return this.model;
    }

    public void reset() {
        this.fields.forEach(field -> field.resetToDefault());
    }

    public void commit() {
        if (this.model != null) {
            this.fields.forEach(field -> field.commit(this.model));
        }
    }

    public void reload() {
        if (this.model != null) {
            this.fields.forEach(field -> field.reload(this.model));
        }
    }

    public <T> Property<T> field(Function<M, WritableValue<T>> accessor) {
        return this.add(new FxPropertyField<T>(accessor));
    }

    public <T> Property<T> field(Function<M, WritableValue<T>> accessor, T defaultValue) {
        return this.add(new FxPropertyField<T>(accessor, defaultValue));
    }

    public <T> Property<T> field(Function<M, T> getter, BiConsumer<M, T> setter) {
        return this.add(new BeanPropertyField<T>(getter, setter));
    }

    public <T> Property<T> field(Function<M, T> getter, BiConsumer<M, T> setter, T defaultValue) {
        return this.add(new BeanPropertyField<T>(getter, setter, defaultValue));
    }

    public <T> Property<T> field(String fieldName, Function<M, WritableValue<T>> accessor) {
        return this.addIdentified(fieldName, new FxPropertyField<T>(accessor));
    }

    public <T> Property<T> field(String fieldName, Function<M, WritableValue<T>> accessor, T defaultValue) {
        return this.addIdentified(fieldName, new FxPropertyField<T>(accessor, defaultValue));
    }

    public <T> Property<T> field(String fieldName, Function<M, T> getter, BiConsumer<M, T> setter) {
        return this.addIdentified(fieldName, new BeanPropertyField<T>(getter, setter));
    }

    public <T> Property<T> field(String fieldName, Function<M, T> getter, BiConsumer<M, T> setter, T defaultValue) {
        return this.addIdentified(fieldName, new BeanPropertyField<T>(getter, setter, defaultValue));
    }

    private <T> Property<T> add(PropertyField<T, M> field) {
        this.fields.add(field);
        if (this.model != null) {
            field.reload(this.model);
        }
        return field.getProperty();
    }

    private <T> Property<T> addIdentified(String fieldName, PropertyField<T, M> field) {
        if (this.identifiedFields.containsKey(fieldName)) {
            Property<?> property = this.identifiedFields.get(fieldName).getProperty();
            return property;
        }
        this.identifiedFields.put(fieldName, field);
        return this.add(field);
    }

    private class BeanPropertyField<T>
    implements PropertyField<T, M> {
        private final ObjectProperty<T> targetProperty;
        private final T defaultValue;
        private final Function<M, T> getter;
        private final BiConsumer<M, T> setter;

        public BeanPropertyField(Function<M, T> getter, BiConsumer<M, T> setter) {
            this(getter, setter, null);
        }

        public BeanPropertyField(Function<M, T> getter, BiConsumer<M, T> setter, T defaultValue) {
            this.defaultValue = defaultValue;
            this.getter = getter;
            this.setter = setter;
            this.targetProperty = new SimpleObjectProperty();
        }

        @Override
        public void commit(M wrappedObject) {
            this.setter.accept(wrappedObject, this.targetProperty.get());
        }

        @Override
        public void reload(M wrappedObject) {
            this.targetProperty.setValue(this.getter.apply(wrappedObject));
        }

        @Override
        public void resetToDefault() {
            this.targetProperty.setValue(this.defaultValue);
        }

        @Override
        public Property<T> getProperty() {
            return this.targetProperty;
        }
    }

    private class FxPropertyField<T>
    implements PropertyField<T, M> {
        private final T defaultValue;
        private final Function<M, WritableValue<T>> accessor;
        private final ObjectProperty<T> targetProperty;

        public FxPropertyField(Function<M, WritableValue<T>> accessor) {
            this(accessor, null);
        }

        public FxPropertyField(Function<M, WritableValue<T>> accessor, T defaultValue) {
            this.accessor = accessor;
            this.defaultValue = defaultValue;
            this.targetProperty = new SimpleObjectProperty();
        }

        @Override
        public void commit(M wrappedObject) {
            this.accessor.apply(wrappedObject).setValue(this.targetProperty.get());
        }

        @Override
        public void reload(M wrappedObject) {
            this.targetProperty.setValue(this.accessor.apply(wrappedObject).getValue());
        }

        @Override
        public void resetToDefault() {
            this.targetProperty.setValue(this.defaultValue);
        }

        @Override
        public Property<T> getProperty() {
            return this.targetProperty;
        }
    }

    private static interface PropertyField<T, M> {
        public void commit(M var1);

        public void reload(M var1);

        public void resetToDefault();

        public Property<T> getProperty();
    }
}

