/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.itemlist;

import de.saxsys.mvvmfx.utils.itemlist.ItemList;
import de.saxsys.mvvmfx.utils.itemlist.ModelToStringFunction;
import de.saxsys.mvvmfx.utils.itemlist.SelectableStringList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.SingleSelectionModel;

public class SelectableItemList<ListType>
extends ItemList<ListType>
implements SelectableStringList {
    private SingleSelectionModel<ListType> selectionModel = new SingleSelectionModel<ListType>(){

        protected int getItemCount() {
            return SelectableItemList.this.modelListProperty().size();
        }

        protected ListType getModelItem(int index) {
            return index == -1 ? null : SelectableItemList.this.modelListProperty().get(index);
        }
    };
    private ObjectProperty<ListType> selectedItem = new SimpleObjectProperty();

    public SelectableItemList(ObservableList<ListType> itemList, ModelToStringFunction<ListType> modelToStringMapper) {
        super(itemList, modelToStringMapper);
        this.selectedItem.set(null);
        this.createIndexEvents();
    }

    private void createIndexEvents() {
        this.selectionModel.selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> bean, Number oldVal, Number newVal) {
                int index = newVal.intValue();
                Object item = index == -1 ? null : SelectableItemList.this.modelListProperty().get(index);
                SelectableItemList.this.selectedItem.set(item);
            }
        });
        this.selectedItem.addListener(new ChangeListener<ListType>(){

            public void changed(ObservableValue<? extends ListType> arg0, ListType oldVal, ListType newVal) {
                if (newVal == null) {
                    SelectableItemList.this.selectionModel.select(-1);
                    SelectableItemList.this.selectedItem.set(null);
                } else {
                    int index = ((ObservableList)SelectableItemList.this.modelListProperty().get()).indexOf(newVal);
                    if (index != -1) {
                        SelectableItemList.this.selectionModel.select(index);
                    } else {
                        SelectableItemList.this.selectedItem.set(oldVal);
                    }
                }
            }
        });
    }

    @Override
    public ReadOnlyIntegerProperty selectedIndexProperty() {
        return this.selectionModel.selectedIndexProperty();
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndexProperty().get();
    }

    @Override
    public ReadOnlyListProperty<String> stringListProperty() {
        return this.targetListProperty();
    }

    public List<String> getStringList() {
        return (List)this.targetListProperty().get();
    }

    public ObjectProperty<ListType> selectedItemProperty() {
        return this.selectedItem;
    }

    public void select(ListType item) {
        this.selectedItem.set(item);
    }

    public ListType getSelectedItem() {
        return (ListType)this.selectedItem.get();
    }

    @Override
    public void clearSelection() {
        this.selectionModel.clearSelection();
    }

    @Override
    public void select(int index) {
        this.selectionModel.select(index);
    }
}

