/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.commands;

import de.saxsys.mvvmfx.utils.commands.CommandBase;
import javafx.application.Platform;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;

public class DelegateCommand
extends CommandBase {
    private final Runnable action;
    private boolean inBackground = false;

    public DelegateCommand(Runnable action) {
        this(action, null, false);
    }

    public DelegateCommand(Runnable action, boolean inBackground) {
        this(action, null, inBackground);
    }

    public DelegateCommand(Runnable action, ObservableBooleanValue executableBinding) {
        this(action, executableBinding, false);
    }

    public DelegateCommand(Runnable action, ObservableBooleanValue executableBinding, boolean inBackground) {
        this.action = action;
        this.inBackground = inBackground;
        if (executableBinding != null) {
            this.executable.bind((ObservableValue)this.runningProperty().not().and(executableBinding));
        }
    }

    @Override
    public void execute() {
        boolean callerOnUIThread = Platform.isFxApplicationThread();
        if (!this.isExecutable()) {
            throw new RuntimeException("The execute()-method of the command was called while it wasn't executable.");
        }
        this.running.set(true);
        if (this.inBackground) {
            new Thread(() -> {
                this.action.run();
                if (callerOnUIThread) {
                    Platform.runLater(() -> this.running.set(false));
                } else {
                    this.running.set(false);
                }
            }).start();
        } else {
            this.action.run();
            this.running.set(false);
        }
    }
}

