/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.commands;

import de.saxsys.mvvmfx.utils.commands.Command;
import de.saxsys.mvvmfx.utils.commands.CommandBase;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class CompositeCommand
extends CommandBase {
    private final ObservableList<Command> registeredCommands = FXCollections.observableArrayList();

    public CompositeCommand(Command ... commands) {
        this.initRegisteredCommandsListener();
        this.registeredCommands.addAll((Object[])commands);
    }

    public void register(Command command) {
        this.registeredCommands.add((Object)command);
    }

    public void unregister(Command command) {
        this.registeredCommands.remove((Object)command);
    }

    private void initRegisteredCommandsListener() {
        this.registeredCommands.addListener(c -> {
            while (c.next()) {
                if (this.registeredCommands.isEmpty()) {
                    this.executable.unbind();
                    this.running.unbind();
                    continue;
                }
                BooleanBinding executableBinding = null;
                BooleanBinding runningBinding = null;
                for (int i = 0; i < this.registeredCommands.size(); ++i) {
                    ReadOnlyBooleanProperty currentExecutable = ((Command)this.registeredCommands.get(i)).executableProperty();
                    ReadOnlyBooleanProperty currentRunning = ((Command)this.registeredCommands.get(i)).runningProperty();
                    if (i == 0) {
                        executableBinding = currentExecutable.and((ObservableBooleanValue)currentExecutable);
                        runningBinding = currentRunning.or((ObservableBooleanValue)currentRunning);
                        continue;
                    }
                    executableBinding = executableBinding.and((ObservableBooleanValue)currentExecutable);
                    runningBinding = runningBinding.or((ObservableBooleanValue)currentRunning);
                }
                this.executable.bind(executableBinding);
                this.running.bind(runningBinding);
            }
        });
    }

    @Override
    public void execute() {
        if (!this.isExecutable()) {
            throw new RuntimeException("Not executable");
        }
        this.registeredCommands.forEach(t -> t.execute());
    }
}

