/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.internal.viewloader;

import de.saxsys.mvvmfx.InjectViewModel;
import de.saxsys.mvvmfx.ViewModel;
import de.saxsys.mvvmfx.internal.viewloader.DependencyInjector;
import de.saxsys.mvvmfx.internal.viewloader.ReflectionUtils;
import de.saxsys.mvvmfx.internal.viewloader.View;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.jodah.typetools.TypeResolver;

public class ViewLoaderReflectionUtils {
    public static Optional<Field> getViewModelField(Class<? extends View> viewType, Class<?> viewModelType) {
        List viewModelFields = Arrays.stream(viewType.getDeclaredFields()).filter(field -> field.isAnnotationPresent(InjectViewModel.class)).filter(field -> field.getType().isAssignableFrom(viewModelType)).collect(Collectors.toList());
        if (viewModelFields.isEmpty()) {
            return Optional.empty();
        }
        if (viewModelFields.size() > 1) {
            throw new RuntimeException("The View <" + viewType + "> may only define one viewModel but there were <" + viewModelFields.size() + "> viewModel fields!");
        }
        return Optional.of(viewModelFields.get(0));
    }

    public static <ViewType extends View<? extends ViewModelType>, ViewModelType extends ViewModel> ViewModelType getExistingViewModel(ViewType view) {
        Class viewModelType = TypeResolver.resolveRawArgument(View.class, view.getClass());
        Optional<Field> fieldOptional = ViewLoaderReflectionUtils.getViewModelField(view.getClass(), viewModelType);
        if (fieldOptional.isPresent()) {
            Field field = fieldOptional.get();
            return (ViewModelType)ReflectionUtils.accessField(field, () -> (ViewModel)field.get(view), "Can't get the viewModel of type <" + viewModelType + ">");
        }
        return null;
    }

    public static void injectViewModel(View view, ViewModel viewModel) {
        if (viewModel == null) {
            return;
        }
        Optional<Field> fieldOptional = ViewLoaderReflectionUtils.getViewModelField(view.getClass(), viewModel.getClass());
        if (fieldOptional.isPresent()) {
            Field field = fieldOptional.get();
            ReflectionUtils.accessField(field, () -> {
                Object existingViewModel = field.get(view);
                if (existingViewModel == null) {
                    field.set(view, viewModel);
                }
            }, "Can't inject ViewModel of type <" + viewModel.getClass() + "> into the view <" + view + ">");
        }
    }

    public static <V extends View<? extends VM>, VM extends ViewModel> Optional<VM> createAndInjectViewModel(V view) {
        Class viewModelType = TypeResolver.resolveRawArgument(View.class, view.getClass());
        if (viewModelType == ViewModel.class) {
            return Optional.empty();
        }
        if (viewModelType == TypeResolver.Unknown.class) {
            return Optional.empty();
        }
        Optional<Field> fieldOptional = ViewLoaderReflectionUtils.getViewModelField(view.getClass(), viewModelType);
        if (fieldOptional.isPresent()) {
            Field field = fieldOptional.get();
            Object viewModel = ReflectionUtils.accessField(field, () -> {
                Object existingViewModel = field.get(view);
                if (existingViewModel != null) {
                    return existingViewModel;
                }
                Object newViewModel = DependencyInjector.getInstance().getInstanceOf(viewModelType);
                field.set(view, newViewModel);
                return newViewModel;
            }, "Can't inject ViewModel of type <" + viewModelType + "> into the view <" + view + ">");
            if (viewModel == null) {
                return Optional.empty();
            }
            try {
                return Optional.of((ViewModel)viewModel);
            }
            catch (ClassCastException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static <ViewType extends View<? extends ViewModelType>, ViewModelType extends ViewModel> ViewModelType createViewModel(ViewType view) {
        Class viewModelType = TypeResolver.resolveRawArgument(View.class, view.getClass());
        if (viewModelType == ViewModel.class) {
            return null;
        }
        if (TypeResolver.Unknown.class == viewModelType) {
            return null;
        }
        return (ViewModelType)((ViewModel)DependencyInjector.getInstance().getInstanceOf(viewModelType));
    }

    public static <ViewModelType extends ViewModel> void initializeViewModel(ViewModelType viewModel) {
        try {
            Method initMethod = viewModel.getClass().getMethod("initialize", new Class[0]);
            AccessController.doPrivileged(() -> {
                try {
                    return initMethod.invoke((Object)viewModel, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException("mvvmFX wasn't able to call the initialize method of ViewModel [" + viewModel + "].", e);
                }
            });
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

