/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.internal.viewloader;

import javafx.util.Callback;

public class DependencyInjector {
    private Callback<Class<?>, Object> customInjector;
    private static DependencyInjector singleton = new DependencyInjector();

    DependencyInjector() {
    }

    public static DependencyInjector getInstance() {
        return singleton;
    }

    public void setCustomInjector(Callback<Class<?>, Object> callback) {
        this.customInjector = callback;
    }

    <T> T getInstanceOf(Class<? extends T> type) {
        if (this.isCustomInjectorDefined()) {
            return (T)this.customInjector.call(type);
        }
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Can't create instance of type " + type.getName() + ". Make sure that the class has a public no-arg constructor.", e);
        }
    }

    Callback<Class<?>, Object> getCustomInjector() {
        return this.customInjector;
    }

    boolean isCustomInjectorDefined() {
        return this.customInjector != null;
    }
}

