/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.listener;

import de.saxsys.mvvmfx.utils.listener.ICleanable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class ListenerManager
implements ICleanable {
    private final Map<ObservableValue<?>, Set<ChangeListener>> simpleChangeListeners = new WeakHashMap();
    private final Map<ObservableList<?>, Set<ListChangeListener>> listChangeListeners = new WeakHashMap();
    private final Map<Observable, Set<InvalidationListener>> invalidationListeners = new WeakHashMap<Observable, Set<InvalidationListener>>();

    public <T> void register(ObservableValue<T> observable, ChangeListener<? super T> listener) {
        if (!this.simpleChangeListeners.containsKey(observable)) {
            this.simpleChangeListeners.put(observable, Collections.newSetFromMap(new WeakHashMap()));
        }
        Set<ChangeListener> observers = this.simpleChangeListeners.get(observable);
        observers.add(listener);
        observable.addListener(listener);
    }

    public <T> void register(ObservableList<T> observable, ListChangeListener<? super T> listener) {
        if (!this.listChangeListeners.containsKey(observable)) {
            this.listChangeListeners.put(observable, Collections.newSetFromMap(new WeakHashMap()));
        }
        Set<ListChangeListener> observers = this.listChangeListeners.get(observable);
        observers.add(listener);
        observable.addListener(listener);
    }

    public void register(Observable observable, InvalidationListener listener) {
        if (!this.invalidationListeners.containsKey(observable)) {
            this.invalidationListeners.put(observable, Collections.newSetFromMap(new WeakHashMap()));
        }
        Set<InvalidationListener> observers = this.invalidationListeners.get(observable);
        observers.add(listener);
        observable.addListener(listener);
    }

    @Override
    public void clean() {
        this.clearMap(this.simpleChangeListeners, (observable, listener) -> observable.removeListener(listener));
        this.clearMap(this.listChangeListeners, (observable, listener) -> observable.removeListener(listener));
        this.clearMap(this.invalidationListeners, (observable, listener) -> observable.removeListener(listener));
    }

    private <T, U> void clearMap(Map<T, Set<U>> map, BiConsumer<T, U> consumer) {
        for (T observable : map.keySet()) {
            for (U listener : map.get(observable)) {
                consumer.accept(observable, listener);
            }
        }
        map.clear();
    }
}

