/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.testingutils;

import java.lang.ref.WeakReference;

public class GCVerifier {
    private WeakReference reference;
    private String objectName;

    GCVerifier(WeakReference reference, String objectName) {
        this.reference = reference;
        this.objectName = objectName;
    }

    public static GCVerifier create(Object instance) {
        return new GCVerifier(new WeakReference<Object>(instance), instance.toString());
    }

    public void verify(String message) {
        GCVerifier.forceGC();
        if (this.reference.get() != null) {
            throw new AssertionError((Object)message);
        }
    }

    public void verify() {
        this.verify("Expected the given object [" + this.objectName + "] to be available for Garbage Collection but it isn't");
    }

    public static void forceGC() {
        Object o = new Object();
        WeakReference<Object> ref = new WeakReference<Object>(o);
        o = null;
        while (ref.get() != null) {
            System.gc();
        }
    }
}

