/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.notifications;

import de.saxsys.mvvmfx.utils.notifications.NotificationCenter;
import de.saxsys.mvvmfx.utils.notifications.NotificationObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DefaultNotificationCenter
implements NotificationCenter {
    private final Map<String, List<NotificationObserver>> observersForName = new HashMap<String, List<NotificationObserver>>();

    DefaultNotificationCenter() {
    }

    @Override
    public void addObserverForName(String name, NotificationObserver observer) {
        List<NotificationObserver> observers = this.observersForName.get(name);
        if (observers == null) {
            this.observersForName.put(name, new ArrayList());
        }
        observers = this.observersForName.get(name);
        observers.add(observer);
    }

    @Override
    public void removeObserverForName(String name, NotificationObserver observer) {
        List<NotificationObserver> observers = this.observersForName.get(name);
        observers.remove(observer);
        if (observers.size() == 0) {
            this.observersForName.remove(name);
        }
    }

    @Override
    public void removeObserver(NotificationObserver observer) {
        block0: for (String key : this.observersForName.keySet()) {
            for (NotificationObserver actualObserver : this.observersForName.get(key)) {
                if (actualObserver != observer) continue;
                this.observersForName.remove(key);
                continue block0;
            }
        }
    }

    @Override
    public void postNotification(String name, Object ... objects) {
        Collection notificationReceivers = this.observersForName.get(name);
        if (notificationReceivers != null) {
            for (NotificationObserver observer : notificationReceivers) {
                observer.receivedNotification(name, objects);
            }
        }
    }
}

