/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.utils.itemlist;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;

public class ListTransformation<SourceType, TargetType> {
    private final Function<SourceType, TargetType> function;
    private ReadOnlyListWrapper<TargetType> viewModelList = new ReadOnlyListWrapper(FXCollections.observableArrayList());
    private ListProperty<SourceType> modelList = new SimpleListProperty();
    private ListChangeListener<SourceType> listChangeListener;

    public ListTransformation(ObservableList<SourceType> modelList, Function<SourceType, TargetType> function) {
        this.function = function;
        this.initListEvents();
        this.modelListProperty().set(modelList);
    }

    public ListTransformation(Function<SourceType, TargetType> function) {
        this(FXCollections.emptyObservableList(), function);
    }

    private void initListEvents() {
        this.listChangeListener = new ListChangeListener<SourceType>(){

            public void onChanged(ListChangeListener.Change<? extends SourceType> listEvent) {
                ArrayList deleteStaging = new ArrayList();
                while (listEvent.next()) {
                    if (listEvent.wasUpdated()) {
                        ListTransformation.this.processUpdateEvent(listEvent);
                        continue;
                    }
                    if (listEvent.wasReplaced()) {
                        ListTransformation.this.processReplaceEvent(listEvent, deleteStaging);
                        continue;
                    }
                    if (listEvent.wasAdded()) {
                        ListTransformation.this.processAddEvent(listEvent);
                        continue;
                    }
                    if (!listEvent.wasRemoved()) continue;
                    ListTransformation.this.processRemoveEvent(listEvent, deleteStaging);
                }
                ListTransformation.this.processStagingLists(deleteStaging);
            }
        };
        this.modelListProperty().addListener((ListChangeListener)new WeakListChangeListener(this.listChangeListener));
    }

    private void processAddEvent(ListChangeListener.Change<? extends SourceType> listEvent) {
        for (int i = listEvent.getFrom(); i < listEvent.getTo(); ++i) {
            Object item = listEvent.getList().get(i);
            this.viewModelList.add(i, this.function.apply(item));
        }
    }

    private void processRemoveEvent(ListChangeListener.Change<? extends SourceType> listEvent, List<TargetType> deleteStaging) {
        for (int i = 0; i < listEvent.getRemovedSize(); ++i) {
            deleteStaging.add(this.viewModelList.get(listEvent.getFrom() + i));
        }
    }

    private void processUpdateEvent(ListChangeListener.Change<? extends SourceType> listEvent) {
        for (int i = listEvent.getFrom(); i < listEvent.getTo(); ++i) {
            Object item = listEvent.getList().get(i);
            this.viewModelList.set(i, this.function.apply(item));
        }
    }

    private void processReplaceEvent(ListChangeListener.Change<? extends SourceType> listEvent, List<TargetType> deletedStaging) {
        this.processRemoveEvent(listEvent, deletedStaging);
        this.processStagingLists(deletedStaging);
        this.processAddEvent(listEvent);
    }

    private void processStagingLists(List<TargetType> deleteStaging) {
        this.viewModelList.removeAll(deleteStaging);
        deleteStaging.clear();
    }

    public ListProperty<SourceType> modelListProperty() {
        return this.modelList;
    }

    public void setModelList(ObservableList<SourceType> modelList) {
        this.modelList.set(modelList);
    }

    public ReadOnlyListProperty<TargetType> targetListProperty() {
        return this.viewModelList.getReadOnlyProperty();
    }
}

