/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.internal.viewloader;

import de.saxsys.mvvmfx.InjectViewModel;
import de.saxsys.mvvmfx.ViewModel;
import de.saxsys.mvvmfx.internal.viewloader.DependencyInjector;
import de.saxsys.mvvmfx.internal.viewloader.View;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import net.jodah.typetools.TypeResolver;

public class ReflectionUtils {
    static Optional<Field> getViewModelField(Class<? extends View> viewType, Class<?> viewModelType) {
        List viewModelFields = Arrays.stream(viewType.getDeclaredFields()).filter(field -> field.isAnnotationPresent(InjectViewModel.class)).filter(field -> field.getType().isAssignableFrom(viewModelType)).collect(Collectors.toList());
        if (viewModelFields.isEmpty()) {
            return Optional.empty();
        }
        if (viewModelFields.size() > 1) {
            throw new RuntimeException("The View <" + viewType + "> may only define one viewModel but there were <" + viewModelFields.size() + "> viewModel fields!");
        }
        return Optional.of(viewModelFields.get(0));
    }

    static <ViewType extends View<? extends ViewModelType>, ViewModelType extends ViewModel> ViewModelType getViewModel(ViewType view) {
        Class viewModelType = TypeResolver.resolveRawArgument(View.class, view.getClass());
        Optional<Field> fieldOptional = ReflectionUtils.getViewModelField(view.getClass(), viewModelType);
        if (fieldOptional.isPresent()) {
            Field field = fieldOptional.get();
            return (ViewModelType)ReflectionUtils.accessField(field, () -> (ViewModel)field.get(view), "Can't get the viewModel of type <" + viewModelType + ">");
        }
        return null;
    }

    static <T> T accessField(Field field, Callable<T> callable, String errorMessage) {
        return (T)AccessController.doPrivileged(() -> {
            boolean wasAccessible = field.isAccessible();
            try {
                field.setAccessible(true);
                if (callable != null) {
                    Object v = callable.call();
                    return v;
                }
            }
            catch (Exception exception) {
                throw new IllegalStateException(errorMessage, exception);
            }
            finally {
                field.setAccessible(wasAccessible);
            }
            return null;
        });
    }

    static void injectViewModel(View view, ViewModel viewModel) {
        if (viewModel == null) {
            return;
        }
        Optional<Field> fieldOptional = ReflectionUtils.getViewModelField(view.getClass(), viewModel.getClass());
        if (fieldOptional.isPresent()) {
            Field field = fieldOptional.get();
            ReflectionUtils.accessField(field, () -> {
                Object existingViewModel = field.get(view);
                if (existingViewModel == null) {
                    field.setAccessible(true);
                    field.set(view, viewModel);
                }
                return null;
            }, "Can't inject ViewModel of type <" + viewModel.getClass() + "> into the view <" + view + ">");
        }
    }

    static <ViewType extends View<? extends ViewModelType>, ViewModelType extends ViewModel> ViewModelType createViewModel(ViewType view) {
        Class viewModelType = TypeResolver.resolveRawArgument(View.class, view.getClass());
        if (viewModelType == ViewModel.class) {
            return null;
        }
        if (TypeResolver.Unknown.class == viewModelType) {
            return null;
        }
        return (ViewModelType)((ViewModel)DependencyInjector.getInstance().getInstanceOf(viewModelType));
    }
}

