/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.internal.viewloader;

import de.saxsys.mvvmfx.ViewModel;
import de.saxsys.mvvmfx.ViewTuple;
import de.saxsys.mvvmfx.internal.viewloader.DependencyInjector;
import de.saxsys.mvvmfx.internal.viewloader.ReflectionUtils;
import de.saxsys.mvvmfx.internal.viewloader.View;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FxmlViewLoader {
    private static final Logger LOG = LoggerFactory.getLogger(FxmlViewLoader.class);

    public <ViewType extends View<? extends ViewModelType>, ViewModelType extends ViewModel> ViewTuple<ViewType, ViewModelType> loadFxmlViewTuple(Class<? extends ViewType> viewType, ResourceBundle resourceBundle, Object controller, Object root, ViewModelType viewModel) {
        String pathToFXML = "/" + viewType.getPackage().getName().replaceAll("\\.", "/") + "/" + viewType.getSimpleName() + ".fxml";
        return this.loadFxmlViewTuple(pathToFXML, resourceBundle, controller, root, viewModel);
    }

    public <ViewType extends View<? extends ViewModelType>, ViewModelType extends ViewModel> ViewTuple<ViewType, ViewModelType> loadFxmlViewTuple(String resource, ResourceBundle resourceBundle, Object controller, Object root, ViewModelType viewModel) {
        try {
            FXMLLoader loader = this.createFxmlLoader(resource, resourceBundle, controller, root, viewModel);
            loader.load();
            View loadedController = (View)loader.getController();
            Parent loadedRoot = (Parent)loader.getRoot();
            if (loadedController == null) {
                throw new IOException("Could not load the controller for the View " + resource + " maybe your missed the fx:controller in your fxml?");
            }
            Object loadedViewModel = ReflectionUtils.getViewModel(loadedController);
            if (loadedViewModel == null) {
                loadedViewModel = ReflectionUtils.createViewModel(loadedController);
            }
            return new ViewTuple(loadedController, loadedRoot, loadedViewModel);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private FXMLLoader createFxmlLoader(String resource, ResourceBundle resourceBundle, Object controller, Object root, ViewModel viewModel) throws IOException {
        URL location = FxmlViewLoader.class.getResource(resource);
        if (location == null) {
            throw new IOException("Error loading FXML - can't load from given resourcepath: " + resource);
        }
        FXMLLoader fxmlLoader = new FXMLLoader();
        fxmlLoader.setRoot(root);
        fxmlLoader.setResources(resourceBundle);
        fxmlLoader.setLocation(location);
        if (viewModel != null && controller == null) {
            fxmlLoader.setControllerFactory((Callback)new ControllerFactoryForCustomViewModel(viewModel));
        } else {
            fxmlLoader.setControllerFactory((Callback)new DefaultControllerFactory());
        }
        if (controller != null) {
            fxmlLoader.setController(controller);
            if (controller instanceof View) {
                View view = (View)controller;
                if (viewModel == null) {
                    ReflectionUtils.injectViewModel(view, ReflectionUtils.createViewModel(view));
                } else {
                    ReflectionUtils.injectViewModel(view, viewModel);
                }
            }
        }
        return fxmlLoader;
    }

    private static class ControllerFactoryForCustomViewModel
    implements Callback<Class<?>, Object> {
        private boolean customViewModelInjected = false;
        private ViewModel customViewModel;

        public ControllerFactoryForCustomViewModel(ViewModel customViewModel) {
            this.customViewModel = customViewModel;
        }

        public Object call(Class<?> type) {
            Object controller = DependencyInjector.getInstance().getInstanceOf(type);
            if (controller instanceof View) {
                View view = (View)controller;
                if (!this.customViewModelInjected) {
                    ReflectionUtils.injectViewModel(view, this.customViewModel);
                    this.customViewModelInjected = true;
                    return view;
                }
                ReflectionUtils.injectViewModel(view, ReflectionUtils.createViewModel(view));
            }
            return controller;
        }
    }

    private static class DefaultControllerFactory
    implements Callback<Class<?>, Object> {
        private DefaultControllerFactory() {
        }

        public Object call(Class<?> type) {
            Object controller = DependencyInjector.getInstance().getInstanceOf(type);
            if (controller instanceof View) {
                View view = (View)controller;
                ReflectionUtils.injectViewModel(view, ReflectionUtils.createViewModel(view));
            }
            return controller;
        }
    }
}

