/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.javafx.test;

import de.saxsys.javafx.test.SingleJfxApplication;
import de.saxsys.javafx.test.TestInJfxThread;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import org.junit.Test;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;

public class JfxRunner
extends BlockJUnit4ClassRunner {
    private static final String ERROR_ON_TIMEOUT = "@TestInJfxThread does not work with timeouts in the @Test Annotation. A possible Workaround might be a timeouted CompletableFuture.";

    public JfxRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
        SingleJfxApplication.startJavaFx();
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        CountDownLatch latch = new CountDownLatch(1);
        TestInJfxThread performMethodInFxThread = (TestInJfxThread)method.getAnnotation(TestInJfxThread.class);
        if (performMethodInFxThread != null) {
            Test annotation = (Test)method.getAnnotation(Test.class);
            long timeout = annotation.timeout();
            if (timeout > 0L) {
                System.err.println(ERROR_ON_TIMEOUT);
                throw new UnsupportedOperationException(ERROR_ON_TIMEOUT);
            }
            Platform.runLater(() -> {
                JfxRunner.super.runChild(method, notifier);
                latch.countDown();
            });
        } else {
            JfxRunner.super.runChild(method, notifier);
            latch.countDown();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

