/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.bindablefx;

import de.saxsys.bindablefx.IFluentBinding;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakListener;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RootBinding<TValue>
extends ObjectBinding<TValue>
implements IFluentBinding<TValue>,
ChangeListener<TValue>,
WeakListener {
    @Nullable
    private WeakReference<ObservableValue<TValue>> observedValue;
    @Nullable
    private Function<TValue, TValue> valueReplacer;
    @Nullable
    private Supplier<TValue> fallbackSupplier;
    @NotNull
    private final List<ChangeListener<? super TValue>> changeListeners = new ArrayList<ChangeListener<? super TValue>>();
    @NotNull
    private final List<InvalidationListener> invalidationListeners = new ArrayList<InvalidationListener>();

    RootBinding() {
    }

    @NotNull
    public Optional<ObservableValue<TValue>> getObservedValue() {
        if (this.observedValue == null) {
            Optional<ObservableValue<TValue>> optional = Optional.empty();
            if (optional == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "de/saxsys/bindablefx/RootBinding", "getObservedValue"));
            }
            return optional;
        }
        Optional<ObservableValue<TValue>> optional = Optional.ofNullable(this.observedValue.get());
        if (optional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "de/saxsys/bindablefx/RootBinding", "getObservedValue"));
        }
        return optional;
    }

    protected final void destroyObservedValue() {
        this.getObservedValue().ifPresent(observedValue -> {
            if (observedValue != null) {
                this.beforeDestroyObservedValue((ObservableValue<TValue>)observedValue);
                observedValue.removeListener((ChangeListener)this);
            }
            this.observedValue = null;
        });
    }

    protected final void setObservedValue(@NotNull ObservableValue<TValue> observedValue) {
        if (observedValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observedValue", "de/saxsys/bindablefx/RootBinding", "setObservedValue"));
        }
        this.observedValue = new WeakReference<ObservableValue<TValue>>(observedValue);
        this.afterSetObservedValue(observedValue);
        observedValue.addListener((ChangeListener)this);
    }

    protected void beforeDestroyObservedValue(@NotNull ObservableValue<TValue> observableValue) {
        if (observableValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observableValue", "de/saxsys/bindablefx/RootBinding", "beforeDestroyObservedValue"));
        }
    }

    protected void afterSetObservedValue(@NotNull ObservableValue<TValue> observableValue) {
        if (observableValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observableValue", "de/saxsys/bindablefx/RootBinding", "afterSetObservedValue"));
        }
    }

    @Nullable
    protected TValue computeValue() {
        Optional<ObservableValue<TValue>> observedValue = this.getObservedValue();
        if (observedValue.isPresent()) {
            return (TValue)(this.valueReplacer != null ? this.valueReplacer.apply(observedValue.get().getValue()) : observedValue.get().getValue());
        }
        if (this.fallbackSupplier != null) {
            return this.fallbackSupplier.get();
        }
        return null;
    }

    public void changed(@Nullable ObservableValue<? extends TValue> observable, @Nullable TValue oldValue, @Nullable TValue newValue) {
        this.invalidate();
    }

    public boolean wasGarbageCollected() {
        return this.observedValue != null && this.observedValue.get() == null;
    }

    @Override
    @NotNull
    public IFluentBinding<TValue> fallbackOn(@Nullable TValue fallbackValue) {
        this.fallbackSupplier = () -> fallbackValue;
        this.invalidate();
        RootBinding rootBinding = this;
        if (rootBinding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "de/saxsys/bindablefx/RootBinding", "fallbackOn"));
        }
        return rootBinding;
    }

    @Override
    @NotNull
    public IFluentBinding<TValue> stopFallbackOn() {
        this.fallbackSupplier = null;
        this.invalidate();
        RootBinding rootBinding = this;
        if (rootBinding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "de/saxsys/bindablefx/RootBinding", "stopFallbackOn"));
        }
        return rootBinding;
    }

    @Override
    public boolean hasFallbackValue() {
        return this.fallbackSupplier != null;
    }

    @Override
    @NotNull
    public IFluentBinding<TValue> replaceWith(@Nullable Function<TValue, TValue> valueReplacer) {
        this.valueReplacer = valueReplacer;
        this.invalidate();
        RootBinding rootBinding = this;
        if (rootBinding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "de/saxsys/bindablefx/RootBinding", "replaceWith"));
        }
        return rootBinding;
    }

    @Override
    @NotNull
    public IFluentBinding<TValue> stopReplacement() {
        if (this.valueReplacer != null) {
            this.valueReplacer = null;
        }
        this.invalidate();
        RootBinding rootBinding = this;
        if (rootBinding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "de/saxsys/bindablefx/RootBinding", "stopReplacement"));
        }
        return rootBinding;
    }

    @Override
    public boolean hasReplacement() {
        return this.valueReplacer != null;
    }

    public void addListener(@NotNull InvalidationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "de/saxsys/bindablefx/RootBinding", "addListener"));
        }
        super.addListener(listener);
        this.invalidationListeners.add(listener);
    }

    public void removeListener(@NotNull InvalidationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "de/saxsys/bindablefx/RootBinding", "removeListener"));
        }
        super.removeListener(listener);
        this.invalidationListeners.remove(listener);
    }

    public void addListener(@NotNull ChangeListener<? super TValue> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "de/saxsys/bindablefx/RootBinding", "addListener"));
        }
        super.addListener(listener);
        this.changeListeners.add(listener);
    }

    public void removeListener(@NotNull ChangeListener<? super TValue> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "de/saxsys/bindablefx/RootBinding", "removeListener"));
        }
        super.removeListener(listener);
        this.changeListeners.remove(listener);
    }

    @Override
    @NotNull
    public IFluentBinding<TValue> stopListeners() {
        while (!this.invalidationListeners.isEmpty()) {
            this.removeListener(this.invalidationListeners.get(0));
        }
        while (!this.changeListeners.isEmpty()) {
            this.removeListener(this.changeListeners.get(0));
        }
        RootBinding rootBinding = this;
        if (rootBinding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "de/saxsys/bindablefx/RootBinding", "stopListeners"));
        }
        return rootBinding;
    }

    @Override
    public boolean hasListeners() {
        return !this.invalidationListeners.isEmpty() || !this.changeListeners.isEmpty();
    }

    public void dispose() {
        this.destroyObservedValue();
        this.stopReplacement();
        this.stopFallbackOn();
        this.stopListeners();
        this.invalidate();
    }
}

