/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.bindablefx;

import de.saxsys.bindablefx.RootBinding;
import java.lang.ref.WeakReference;
import java.util.function.Function;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.jetbrains.annotations.NotNull;

public class RelayBinding<TParentValue, TValue, TObservedValue extends ObservableValue<TValue>>
extends RootBinding<TValue> {
    @NotNull
    private final Function<TParentValue, TObservedValue> relayResolver;
    @NotNull
    private final WeakReference<ObservableValue<TParentValue>> parent;
    @NotNull
    private final ChangeListener<TParentValue> onParentChanged;

    RelayBinding(@NotNull ObservableValue<TParentValue> parent, @NotNull Function<TParentValue, TObservedValue> relayResolver) {
        this.relayResolver = relayResolver;
        this.onParentChanged = (observable, oldValue, newValue) -> {
            this.destroyObservedValue();
            if (newValue != null) {
                this.setObservedValue((ObservableValue)relayResolver.apply(newValue));
            }
            this.invalidate();
        };
        this.parent = new WeakReference<ObservableValue<TParentValue>>(parent);
        parent.addListener(this.onParentChanged);
        this.onParentChanged.changed(parent, null, parent.getValue());
    }

    @Override
    public void dispose() {
        super.dispose();
        ObservableValue parent = (ObservableValue)this.parent.get();
        if (parent != null) {
            parent.removeListener(this.onParentChanged);
        }
    }
}

