/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.bindablefx;

import de.saxsys.bindablefx.Bindings;
import de.saxsys.bindablefx.IConverter;
import de.saxsys.bindablefx.IPropertyBinding;
import de.saxsys.bindablefx.RelayBinding;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PropertyBinding<TParentValue, TValue, TProperty extends Property<TValue>>
extends RelayBinding<TParentValue, TValue, TProperty>
implements IPropertyBinding<TValue> {
    @Nullable
    private WeakReference<ObservableValue<? extends TValue>> boundValue;
    @NotNull
    private final List<WeakReference<Property>> bidirectionalBoundProperties;
    @Nullable
    private TValue memorizedValue;

    PropertyBinding(@NotNull ObservableValue<TParentValue> parent, @NotNull Function<TParentValue, TProperty> nestedResolver) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "de/saxsys/bindablefx/PropertyBinding", "<init>"));
        }
        if (nestedResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nestedResolver", "de/saxsys/bindablefx/PropertyBinding", "<init>"));
        }
        super(parent, nestedResolver);
        this.bidirectionalBoundProperties = new ArrayList<WeakReference<Property>>();
    }

    @Override
    protected void beforeDestroyObservedValue(@NotNull ObservableValue<TValue> observableValue) {
        if (observableValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observableValue", "de/saxsys/bindablefx/PropertyBinding", "beforeDestroyObservedValue"));
        }
        this.getObservedValue().ifPresent(observedValue -> {
            if (this.isBound()) {
                ((Property)observedValue).unbind();
            }
        });
    }

    @Override
    protected void afterSetObservedValue(@NotNull ObservableValue<TValue> observableValue) {
        if (observableValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observableValue", "de/saxsys/bindablefx/PropertyBinding", "afterSetObservedValue"));
        }
        if (this.boundValue != null) {
            ObservableValue boundTo = (ObservableValue)this.boundValue.get();
            ((Property)observableValue).bind(boundTo);
        } else if (this.memorizedValue != null) {
            this.setValue(this.memorizedValue);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.unbind();
        this.unbindBidirectional();
    }

    public void setValue(TValue value) {
        if (this.isBound()) {
            throw new IllegalStateException((this.getBean() != null && this.getName() != null ? this.getBean().getClass().getSimpleName() + "." + this.getName() + " : " : "") + "A bound value cannot be set.");
        }
        Optional observedValue = this.getObservedValue();
        if (observedValue.isPresent()) {
            ((Property)observedValue.get()).setValue(value);
            this.memorizedValue = null;
        } else {
            this.memorizedValue = value;
        }
    }

    public Object getBean() {
        Optional currentProperty = this.getObservedValue();
        return currentProperty.isPresent() ? ((Property)currentProperty.get()).getBean() : null;
    }

    public String getName() {
        Optional currentProperty = this.getObservedValue();
        return currentProperty.isPresent() ? ((Property)currentProperty.get()).getName() : null;
    }

    public void bind(@NotNull ObservableValue<? extends TValue> observable) {
        if (observable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observable", "de/saxsys/bindablefx/PropertyBinding", "bind"));
        }
        this.memorizedValue = null;
        this.boundValue = new WeakReference<ObservableValue<TValue>>(observable);
        this.getObservedValue().ifPresent(observedValue -> {
            if (observable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observable", "de/saxsys/bindablefx/PropertyBinding", "lambda$bind$1"));
            }
            if (((Property)observedValue).isBound()) {
                ((Property)observedValue).unbind();
            }
            ((Property)observedValue).bind(observable);
        });
    }

    public void unbind() {
        if (this.isBound()) {
            this.getObservedValue().ifPresent(property -> ((Property)property).unbind());
            this.boundValue = null;
        }
    }

    public boolean isBound() {
        return this.boundValue != null && this.boundValue.get() != null;
    }

    public void bindBidirectional(@NotNull Property<TValue> other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "de/saxsys/bindablefx/PropertyBinding", "bindBidirectional"));
        }
        this.memorizedValue = null;
        javafx.beans.binding.Bindings.bindBidirectional((Property)this, other);
        this.bidirectionalBoundProperties.add(new WeakReference<Property<TValue>>(other));
    }

    public void unbindBidirectional(@NotNull Property<TValue> other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "de/saxsys/bindablefx/PropertyBinding", "unbindBidirectional"));
        }
        this.unbindProperty(other);
    }

    @Override
    public <TOtherValue> void bindBidirectional(@NotNull Property<TOtherValue> other, @NotNull IConverter<TValue, TOtherValue> converter) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "de/saxsys/bindablefx/PropertyBinding", "bindBidirectional"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "de/saxsys/bindablefx/PropertyBinding", "bindBidirectional"));
        }
        this.memorizedValue = null;
        Bindings.bindBidirectional(this, other, converter);
        this.bidirectionalBoundProperties.add(new WeakReference<Property<TOtherValue>>(other));
    }

    @Override
    public <IOtherValue> void unbindBidirectionalConverted(@NotNull Property<IOtherValue> other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "de/saxsys/bindablefx/PropertyBinding", "unbindBidirectionalConverted"));
        }
        this.unbindProperty(other);
    }

    @Override
    public void unbindBidirectional() {
        while (!this.bidirectionalBoundProperties.isEmpty()) {
            Property prop = (Property)this.bidirectionalBoundProperties.get(0).get();
            if (prop != null) {
                javafx.beans.binding.Bindings.unbindBidirectional((Property)this, (Property)prop);
                Bindings.unbindBidirectional(this, prop);
            }
            this.bidirectionalBoundProperties.remove(0);
        }
    }

    @Override
    public boolean isBidirectionalBound() {
        return !this.bidirectionalBoundProperties.isEmpty();
    }

    private void unbindProperty(@NotNull Property other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "de/saxsys/bindablefx/PropertyBinding", "unbindProperty"));
        }
        for (int i = 0; i < this.bidirectionalBoundProperties.size(); ++i) {
            Property prop = (Property)this.bidirectionalBoundProperties.get(i).get();
            if (prop != null && prop != other) continue;
            javafx.beans.binding.Bindings.unbindBidirectional((Property)this, (Property)other);
            Bindings.unbindBidirectional(this, other);
            this.bidirectionalBoundProperties.remove(i--);
        }
    }
}

