/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.bindablefx;

import de.saxsys.bindablefx.RootBinding;
import java.lang.ref.WeakReference;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import org.jetbrains.annotations.NotNull;

class ConverterBinding<TValue, TConvertedValue>
extends RootBinding<TConvertedValue> {
    @NotNull
    private final Function<TValue, TConvertedValue> converter;
    @NotNull
    private final WeakReference<ObservableValue<TValue>> parent;

    ConverterBinding(@NotNull ObservableValue<TValue> parent, @NotNull Function<TValue, TConvertedValue> converter) {
        this.parent = new WeakReference<ObservableValue<TValue>>(parent);
        this.converter = converter;
        this.bind(new Observable[]{parent});
    }

    @Override
    protected TConvertedValue computeValue() {
        ObservableValue observedValue = (ObservableValue)this.parent.get();
        if (observedValue != null) {
            return this.converter.apply(observedValue.getValue());
        }
        return (TConvertedValue)super.computeValue();
    }

    @Override
    public void dispose() {
        super.dispose();
        ObservableValue observableValue = (ObservableValue)this.parent.get();
        if (observableValue != null) {
            this.unbind(new Observable[]{observableValue});
            this.parent.clear();
        }
    }
}

