/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.bindablefx;

import de.saxsys.bindablefx.IConverter;
import java.lang.ref.WeakReference;
import javafx.beans.WeakListener;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BidirectionalBinding<TValue>
implements ChangeListener<TValue>,
WeakListener {
    private final int cachedHashCode;

    private BidirectionalBinding(@NotNull Object property1, @NotNull Object property2) {
        if (property1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property1", "de/saxsys/bindablefx/BidirectionalBinding", "<init>"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property2", "de/saxsys/bindablefx/BidirectionalBinding", "<init>"));
        }
        this.cachedHashCode = property1.hashCode() * property2.hashCode();
    }

    private static void checkParametersOrFail(Object property1, Object property2) {
        if (property1 == null || property2 == null) {
            throw new NullPointerException("Both properties must be specified.");
        }
        if (property1 == property2) {
            throw new IllegalArgumentException("Cannot bind property to itself");
        }
    }

    @Nullable
    protected abstract Object getProperty1();

    @Nullable
    protected abstract Object getProperty2();

    public boolean wasGarbageCollected() {
        return this.getProperty1() == null || this.getProperty2() == null;
    }

    public int hashCode() {
        return this.cachedHashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Object propertyA1 = this.getProperty1();
        Object propertyA2 = this.getProperty2();
        if (propertyA1 == null || propertyA2 == null) {
            return false;
        }
        if (obj instanceof BidirectionalBinding) {
            BidirectionalBinding otherBinding = (BidirectionalBinding)obj;
            Object propertyB1 = otherBinding.getProperty1();
            Object propertyB2 = otherBinding.getProperty2();
            return propertyB1 != null && propertyB2 != null && (propertyA1 == propertyB1 && propertyA2 == propertyB2 || propertyA1 == propertyB2 && propertyA2 == propertyB1);
        }
        return false;
    }

    public static <TValue, TOtherValue> BidirectionalBinding<Object> bind(@NotNull Property<TValue> property1, @NotNull Property<TOtherValue> property2, @NotNull IConverter<TValue, TOtherValue> converter) {
        if (property1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property1", "de/saxsys/bindablefx/BidirectionalBinding", "bind"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property2", "de/saxsys/bindablefx/BidirectionalBinding", "bind"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "de/saxsys/bindablefx/BidirectionalBinding", "bind"));
        }
        BidirectionalBinding.checkParametersOrFail(property1, property2);
        if (converter == null) {
            throw new NullPointerException("IConverter cannot be null");
        }
        BidirectionalConverterBinding<TValue, TOtherValue> binding = new BidirectionalConverterBinding<TValue, TOtherValue>(property1, property2, converter);
        property1.setValue(converter.convertBack(property2.getValue()));
        property1.addListener(binding);
        property2.addListener(binding);
        return binding;
    }

    public static <TValue, TOtherValue> void unbind(@NotNull Property<TValue> property1, @NotNull Property<TOtherValue> property2) {
        if (property1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property1", "de/saxsys/bindablefx/BidirectionalBinding", "unbind"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property2", "de/saxsys/bindablefx/BidirectionalBinding", "unbind"));
        }
        BidirectionalBinding.checkParametersOrFail(property1, property2);
        UntypedGenericBidirectionalBinding binding = new UntypedGenericBidirectionalBinding(property1, property2);
        property1.removeListener((ChangeListener)binding);
        property2.removeListener((ChangeListener)binding);
    }

    public static void unbind(@NotNull Object property1, @NotNull Object property2) {
        if (property1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property1", "de/saxsys/bindablefx/BidirectionalBinding", "unbind"));
        }
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property2", "de/saxsys/bindablefx/BidirectionalBinding", "unbind"));
        }
        BidirectionalBinding.checkParametersOrFail(property1, property2);
        UntypedGenericBidirectionalBinding binding = new UntypedGenericBidirectionalBinding(property1, property2);
        if (property1 instanceof ObservableValue) {
            ((ObservableValue)property1).removeListener((ChangeListener)binding);
        }
        if (property2 instanceof ObservableValue) {
            ((ObservableValue)property2).removeListener((ChangeListener)binding);
        }
    }

    private static class UntypedGenericBidirectionalBinding
    extends BidirectionalBinding<Object> {
        @NotNull
        private final Object property1;
        @NotNull
        private final Object property2;

        public UntypedGenericBidirectionalBinding(@NotNull Object property1, @NotNull Object property2) {
            if (property1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property1", "de/saxsys/bindablefx/BidirectionalBinding$UntypedGenericBidirectionalBinding", "<init>"));
            }
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property2", "de/saxsys/bindablefx/BidirectionalBinding$UntypedGenericBidirectionalBinding", "<init>"));
            }
            super(property1, property2);
            this.property1 = property1;
            this.property2 = property2;
        }

        @Override
        @Nullable
        protected Object getProperty1() {
            return this.property1;
        }

        @Override
        @Nullable
        protected Object getProperty2() {
            return this.property2;
        }

        public void changed(ObservableValue<? extends Object> sourceProperty, Object oldValue, Object newValue) {
            throw new RuntimeException("Should not reach here");
        }
    }

    private static class BidirectionalConverterBinding<TValue, TOtherValue>
    extends BidirectionalBinding<Object> {
        @NotNull
        private final WeakReference<Property<TValue>> property1;
        @NotNull
        private final WeakReference<Property<TOtherValue>> property2;
        @NotNull
        private final IConverter<TValue, TOtherValue> converter;
        private boolean updating;

        BidirectionalConverterBinding(@NotNull Property<TValue> property1, @NotNull Property<TOtherValue> property2, @NotNull IConverter<TValue, TOtherValue> converter) {
            if (property1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property1", "de/saxsys/bindablefx/BidirectionalBinding$BidirectionalConverterBinding", "<init>"));
            }
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property2", "de/saxsys/bindablefx/BidirectionalBinding$BidirectionalConverterBinding", "<init>"));
            }
            if (converter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "de/saxsys/bindablefx/BidirectionalBinding$BidirectionalConverterBinding", "<init>"));
            }
            super(property1, property2);
            this.updating = false;
            this.property1 = new WeakReference<Property<TValue>>(property1);
            this.property2 = new WeakReference<Property<TOtherValue>>(property2);
            this.converter = converter;
        }

        @Nullable
        protected Property<TValue> getProperty1() {
            return (Property)this.property1.get();
        }

        @Nullable
        protected Property<TOtherValue> getProperty2() {
            return (Property)this.property2.get();
        }

        public void changed(@NotNull ObservableValue<?> observable, @Nullable Object oldValue, @Nullable Object newValue) {
            if (observable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observable", "de/saxsys/bindablefx/BidirectionalBinding$BidirectionalConverterBinding", "changed"));
            }
            if (!this.updating) {
                Property property = (Property)this.property1.get();
                Property otherProperty = (Property)this.property2.get();
                if (property == null || otherProperty == null) {
                    if (property != null) {
                        property.removeListener((ChangeListener)this);
                    }
                    if (otherProperty != null) {
                        otherProperty.removeListener((ChangeListener)this);
                    }
                } else {
                    try {
                        this.updating = true;
                        if (property == observable) {
                            otherProperty.setValue(this.converter.convertTo(property.getValue()));
                        } else {
                            property.setValue(this.converter.convertBack(otherProperty.getValue()));
                        }
                    }
                    catch (RuntimeException e) {
                        try {
                            if (property == observable) {
                                property.setValue(oldValue);
                            } else {
                                otherProperty.setValue(oldValue);
                            }
                        }
                        catch (Exception e2) {
                            e2.addSuppressed(e);
                            com.sun.javafx.binding.BidirectionalBinding.unbind((Object)property, (Object)otherProperty);
                            throw new RuntimeException("Bidirectional binding failed together with an attempt to restore the source property1 to the previous value. Removing the bidirectional binding from properties " + property + " and " + otherProperty, e2);
                        }
                        throw new RuntimeException("Bidirectional binding failed, setting to the previous value", e);
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }
    }
}

