/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.bindablefx;

import java.lang.ref.WeakReference;
import java.util.Optional;
import javafx.beans.WeakListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBinding<TPropertyValue>
implements ChangeListener<TPropertyValue>,
WeakListener {
    @Nullable
    private WeakReference<ObservableValue<TPropertyValue>> observedProperty;

    public Optional<TPropertyValue> getCurrentObservedValue() {
        if (this.observedProperty == null) {
            return Optional.empty();
        }
        ObservableValue property = (ObservableValue)this.observedProperty.get();
        if (property != null) {
            return Optional.ofNullable(property.getValue());
        }
        return Optional.empty();
    }

    void destroyObservedProperty() {
        if (this.observedProperty != null) {
            ObservableValue property = (ObservableValue)this.observedProperty.get();
            if (property != null) {
                property.removeListener((ChangeListener)this);
                this.changed(property, property.getValue(), null);
            }
            this.observedProperty = null;
        }
    }

    void createObservedProperty(@NotNull ObservableValue<TPropertyValue> observedProperty) {
        if (observedProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observedProperty", "de/saxsys/bindablefx/BaseBinding", "createObservedProperty"));
        }
        this.observedProperty = new WeakReference<ObservableValue<TPropertyValue>>(observedProperty);
        observedProperty.addListener((ChangeListener)this);
        this.changed(observedProperty, null, observedProperty.getValue());
    }

    public void dispose() {
        this.destroyObservedProperty();
    }

    public boolean wasGarbageCollected() {
        return this.observedProperty != null && this.observedProperty.get() == null;
    }
}

