/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.tests;

import de.saumya.mojo.gem.AbstractGemMojo;
import de.saumya.mojo.jruby.JRubyVersion;
import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import de.saumya.mojo.tests.JRubyRun;
import de.saumya.mojo.tests.TestScriptFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractTestMojo
extends AbstractGemMojo {
    protected File testReportDirectory;
    protected boolean skipTests;
    protected boolean skip;
    protected Boolean use18and19;
    protected String modes;
    protected String versions;
    protected File summaryReport;

    private JRubyVersion.Mode[] calculateModes(JRubyVersion.Mode defaultMode) {
        ArrayList<JRubyVersion.Mode> result = new ArrayList<JRubyVersion.Mode>();
        if (this.use18and19 != null && this.use18and19.booleanValue()) {
            this.getLog().warn((CharSequence)"use18and19 is deprecated - use modes instead");
            result.add(JRubyVersion.Mode._18);
            result.add(JRubyVersion.Mode._19);
        } else if (this.jrubySwitches != null) {
            for (JRubyVersion.Mode m : JRubyVersion.Mode.values()) {
                if (!this.jrubySwitches.contains(m.flag)) continue;
                result.add(m);
            }
        }
        if (this.modes != null) {
            String[] modes;
            for (String m : modes = this.modes.split("[\\ ,;]+")) {
                JRubyVersion.Mode mode = JRubyVersion.Mode.valueOf((String)("_" + m.replace(".", "")));
                if (result.contains(mode)) continue;
                result.add(mode);
            }
        }
        if (result.size() == 0) {
            result.add(defaultMode);
        }
        return result.toArray(new JRubyVersion.Mode[result.size()]);
    }

    private JRubyVersion[] calculateVersions() {
        if (this.versions == null) {
            return new JRubyVersion[]{this.getJrubyVersion()};
        }
        String[] jrubyVersions = this.versions.split("[\\ ,;]+");
        JRubyVersion[] result = new JRubyVersion[jrubyVersions.length];
        int i = 0;
        for (String version : jrubyVersions) {
            result[i++] = new JRubyVersion(version);
        }
        return result;
    }

    protected void executeWithGems() throws MojoExecutionException, IOException, ScriptException, GemException {
        boolean hasOverview;
        this.testReportDirectory = new File(this.testReportDirectory.getAbsolutePath().replace("${project.basedir}/", ""));
        ArrayList<JRubyRun> runs = new ArrayList<JRubyRun>();
        JRubyVersion[] versions = this.calculateVersions();
        JRubyVersion.Mode[] modes = this.calculateModes(this.getJrubyVersion().defaultMode());
        if (versions.length == 1 && versions[0].equals((Object)this.getJrubyVersion()) && modes.length == 1 && modes[0] == this.getJrubyVersion().defaultMode()) {
            runs.add(new JRubyRun(this.getJrubyVersion()));
        } else {
            for (JRubyVersion version : versions) {
                runs.add(new JRubyRun(version, modes));
            }
        }
        File outputDir = new File(this.project.getBuild().getDirectory().replace("${project.basedir}/", ""));
        TestScriptFactory scriptFactory = null;
        for (JRubyRun run : runs) {
            scriptFactory = this.newTestScriptFactory();
            scriptFactory.setBaseDir(this.project.getBasedir());
            scriptFactory.setGemHome(this.gemsConfig.getGemHome());
            scriptFactory.setGemPaths(this.gemsConfig.getGemPath());
            scriptFactory.setOutputDir(outputDir);
            scriptFactory.setSystemProperties(this.project.getProperties());
            scriptFactory.setSummaryReport(this.summaryReport);
            scriptFactory.setReportPath(this.testReportDirectory);
            try {
                scriptFactory.setClasspathElements(this.project.getTestClasspathElements());
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("error getting classpath", (Exception)((Object)e));
            }
            this.runIt(run, scriptFactory);
        }
        scriptFactory.emit();
        boolean bl = hasOverview = this.versions != null || modes != null || this.use18and19 != null && this.use18and19 != false;
        if (hasOverview) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"\tOverall Summary");
            this.getLog().info((CharSequence)"\t===============");
        }
        boolean failure = false;
        for (JRubyRun run : runs) {
            for (JRubyVersion.Mode mode : run.modes) {
                if (hasOverview) {
                    this.getLog().info((CharSequence)("\t" + run.toString(mode)));
                }
                failure |= !run.result((JRubyVersion.Mode)mode).success;
            }
        }
        if (hasOverview) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("use '" + scriptFactory.getScriptFile() + "' for faster command line execution."));
        }
        if (failure) {
            throw new MojoExecutionException("There were test failures");
        }
    }

    protected void runIt(JRubyRun run, TestScriptFactory testScriptFactory) throws MojoExecutionException, IOException, ScriptException {
        ScriptFactory factory;
        if (this.getJrubyVersion().equals((Object)run.version)) {
            factory = this.factory;
        } else {
            try {
                factory = this.newScriptFactory(this.resolveJRubyCompleteArtifact(run.version.toString()));
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("could not resolve jruby", (Exception)((Object)e));
            }
        }
        for (JRubyVersion.Mode mode : run.modes) {
            JRubyVersion version = null;
            this.getLog().info((CharSequence)"");
            if (!run.isDefaultModeOnly) {
                factory.addSwitch(mode.flag);
                this.getLog().info((CharSequence)("\trun with jruby " + run.version + " in mode " + mode));
                version = run.version;
            } else {
                this.getLog().info((CharSequence)("\trun with jruby " + run.version));
                mode = null;
                version = null;
            }
            this.getLog().info((CharSequence)"");
            run.setResult(mode, this.runIt(factory, mode, version, testScriptFactory));
        }
    }

    protected abstract TestScriptFactory newTestScriptFactory();

    protected abstract JRubyRun.Result runIt(ScriptFactory var1, JRubyVersion.Mode var2, JRubyVersion var3, TestScriptFactory var4) throws IOException, ScriptException, MojoExecutionException;
}

