/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.tests;

import de.saumya.mojo.jruby.JRubyVersion;
import de.saumya.mojo.tests.JRubyRun;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.codehaus.plexus.util.FileUtils;

public class TestResultManager {
    private final String projectName;
    private final File testReportDirectory;
    private final File summaryReport;
    private final String filename;

    public TestResultManager(File summaryReport) {
        this(null, null, null, summaryReport);
    }

    public TestResultManager(String projectName, String filename, File testReportDirectory, File summaryReport) {
        this.projectName = projectName;
        this.filename = filename == null ? null : "TEST-" + filename;
        this.testReportDirectory = testReportDirectory;
        this.summaryReport = summaryReport;
    }

    public JRubyRun.Result generateReports(JRubyVersion.Mode mode, JRubyVersion version, File outputfile) throws IOException {
        JRubyRun.Result result = new JRubyRun.Result();
        String time = null;
        for (Object lineObj : FileUtils.loadFile((File)outputfile)) {
            String line = lineObj.toString();
            if (line.contains("Finished")) {
                time = line.replaceFirst(",.*$", "").replaceAll("[a-zA-Z]+", "").trim();
            }
            if (!line.contains("failures")) continue;
            result.message = line;
            int[] vector = new int[5];
            int i = 0;
            String statusLine = line.replaceAll("[a-z]+,?", "");
            for (String n : statusLine.split("\\s+")) {
                vector[i++] = Integer.parseInt(n);
            }
            boolean bl = result.success = vector[ResultEnum.FAILURES.ordinal()] == 0 && vector[ResultEnum.ERRORS.ordinal()] == 0;
            if (this.filename != null || this.summaryReport != null) {
                String surefireXml = MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<testsuite time=\"{0}\" errors=\"{1}\" tests=\"{2}\" skipped=\"{3}\" failures=\"{4}\" name=\"{5}\">\n</testsuite>\n", time, vector[ResultEnum.ERRORS.ordinal()], vector[ResultEnum.TESTS.ordinal()], vector[ResultEnum.SKIPS.ordinal()], vector[ResultEnum.FAILURES.ordinal()], this.projectName);
                if (this.filename != null) {
                    this.testReportDirectory.mkdirs();
                    String filename = this.filename + (version == null ? "" : "-" + version) + (mode == null ? "" : mode.flag) + ".xml";
                    FileUtils.fileWrite((String)new File(this.testReportDirectory, filename).getAbsolutePath(), (String)"UTF-8", (String)surefireXml);
                }
                if (this.summaryReport != null) {
                    FileUtils.fileWrite((String)this.summaryReport.getAbsolutePath(), (String)"UTF-8", (String)surefireXml);
                }
            }
            return result;
        }
        result.message = "did not find test summary";
        result.success = false;
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ResultEnum {
        TESTS,
        ASSERTIONS,
        FAILURES,
        ERRORS,
        SKIPS;

    }
}

