/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.tests;

import de.saumya.mojo.gem.AbstractGemMojo;
import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import de.saumya.mojo.tests.JRubyRun;
import de.saumya.mojo.tests.TestScriptFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;

public abstract class AbstractTestMojo
extends AbstractGemMojo {
    protected File testReportDirectory;
    protected boolean skipTests;
    protected boolean skip;
    protected Boolean use18and19;
    private String versions;
    protected File summaryReport;

    protected void executeWithGems() throws MojoExecutionException, IOException, ScriptException, GemException {
        boolean hasOverview;
        JRubyRun.Mode mode;
        this.testReportDirectory = new File(this.testReportDirectory.getAbsolutePath().replace("${project.basedir}/", ""));
        ArrayList<JRubyRun> runs = new ArrayList<JRubyRun>();
        if (this.versions == null) {
            mode = this.use18and19 == null ? JRubyRun.Mode.DEFAULT : JRubyRun.Mode._18_19;
            runs.add(new JRubyRun(mode, this.jrubyVersion));
        } else {
            String[] jrubyVersions;
            mode = this.use18and19 == null || !this.use18and19.booleanValue() ? (this.jrubySwitches != null ? (this.jrubySwitches.contains("--1.9") ? JRubyRun.Mode._19 : JRubyRun.Mode._18) : JRubyRun.Mode.DEFAULT) : JRubyRun.Mode._18_19;
            for (String version : jrubyVersions = this.versions.split("[\\ ,;]+")) {
                JRubyRun run = new JRubyRun(mode, version);
                runs.add(run);
            }
        }
        File outputDir = new File(this.project.getBuild().getDirectory().replace("${project.basedir}/", ""));
        TestScriptFactory scriptFactory = null;
        for (JRubyRun run : runs) {
            scriptFactory = this.newTestScriptFactory(run.mode);
            scriptFactory.setBaseDir(this.project.getBasedir());
            scriptFactory.setGemHome(this.gemsConfig.getGemHome());
            scriptFactory.setGemPaths(this.gemsConfig.getGemPath());
            scriptFactory.setOutputDir(outputDir);
            scriptFactory.setSystemProperties(this.project.getProperties());
            scriptFactory.setSummaryReport(this.summaryReport);
            scriptFactory.setReportPath(this.testReportDirectory);
            try {
                scriptFactory.setClasspathElements(this.project.getTestClasspathElements());
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("error getting classpath", (Exception)((Object)e));
            }
            this.runIt(run, scriptFactory);
        }
        scriptFactory.emit();
        boolean bl = hasOverview = this.versions != null || this.use18and19 != null && this.use18and19 != false;
        if (hasOverview) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"\tOverall Summary");
            this.getLog().info((CharSequence)"\t===============");
        }
        boolean failure = false;
        for (JRubyRun run : runs) {
            for (JRubyRun.Mode mode2 : run.asSingleModes()) {
                if (hasOverview) {
                    this.getLog().info((CharSequence)("\t" + run.toString(mode2)));
                }
                failure |= !run.result((JRubyRun.Mode)mode2).success;
            }
        }
        if (hasOverview) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("use '" + scriptFactory.getScriptFile() + "' for faster command line execution."));
        }
        if (failure) {
            throw new MojoExecutionException("There were test failures");
        }
    }

    protected void runIt(JRubyRun run, TestScriptFactory testScriptFactory) throws MojoExecutionException, IOException, ScriptException {
        ScriptFactory factory;
        if (this.jrubyVersion.equals(run.version) || run.mode == JRubyRun.Mode.DEFAULT) {
            factory = this.factory;
        } else {
            try {
                factory = this.newScriptFactory(this.resolveJRubyCompleteArtifact(run.version));
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("could not resolve jruby", (Exception)((Object)e));
            }
        }
        for (JRubyRun.Mode mode : run.asSingleModes()) {
            this.getLog().info((CharSequence)"");
            if (mode != JRubyRun.Mode.DEFAULT) {
                factory.addSwitch(mode.flag);
                this.getLog().info((CharSequence)("\trun with jruby " + run.version + " in mode " + (Object)((Object)mode)));
            } else {
                this.getLog().info((CharSequence)("\trun with jruby " + run.version));
            }
            this.getLog().info((CharSequence)"");
            run.setResult(mode, this.runIt(factory, mode, run.version, testScriptFactory));
        }
    }

    protected abstract TestScriptFactory newTestScriptFactory(JRubyRun.Mode var1);

    protected abstract JRubyRun.Result runIt(ScriptFactory var1, JRubyRun.Mode var2, String var3, TestScriptFactory var4) throws IOException, ScriptException, MojoExecutionException;
}

