/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.runit;

import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import de.saumya.mojo.runit.RunitMavenTestScriptFactory;
import de.saumya.mojo.tests.AbstractTestMojo;
import de.saumya.mojo.tests.JRubyRun;
import de.saumya.mojo.tests.TestResultManager;
import de.saumya.mojo.tests.TestScriptFactory;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class RUnitMojo
extends AbstractTestMojo {
    private final String runitDirectory;
    private final String runitArgs;
    protected boolean skipRunit;
    private TestResultManager resultManager;
    private File outputfile;

    public RUnitMojo() {
        this.runitDirectory = null;
        this.runitArgs = null;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || this.skipTests || this.skipRunit) {
            this.getLog().info((CharSequence)"Skipping RUnit tests");
            return;
        }
        this.outputfile = new File(this.project.getBuild().getDirectory().replace("${project.basedir}/", ""), "runit.txt");
        if (this.outputfile.exists()) {
            this.outputfile.delete();
        }
        this.resultManager = new TestResultManager(this.project.getName(), "runit", this.testReportDirectory, this.summaryReport);
        super.execute();
    }

    protected JRubyRun.Result runIt(ScriptFactory factory, JRubyRun.Mode mode, String version, TestScriptFactory scriptFactory) throws IOException, ScriptException, MojoExecutionException {
        scriptFactory.setOutputDir(this.outputfile.getParentFile());
        scriptFactory.setReportPath(this.outputfile);
        if (this.runitDirectory.startsWith(this.launchDirectory().getAbsolutePath())) {
            scriptFactory.setSourceDir(new File(this.runitDirectory));
        } else {
            scriptFactory.setSourceDir(new File(this.launchDirectory(), this.runitDirectory));
        }
        Script script = factory.newScript(scriptFactory.getCoreScript());
        if (this.runitArgs != null) {
            script.addArgs(this.runitArgs);
        }
        if (this.args != null) {
            script.addArgs(this.args);
        }
        try {
            script.executeIn(this.launchDirectory());
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)"exception in running tests", (Throwable)e);
        }
        return this.resultManager.generateReports(mode, version, this.outputfile);
    }

    protected TestScriptFactory newTestScriptFactory(JRubyRun.Mode mode) {
        return new RunitMavenTestScriptFactory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ResultEnum {
        TESTS,
        ASSERTIONS,
        FAILURES,
        ERRORS,
        SKIPS;

    }
}

