/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.tests;

public class JRubyRun {
    public final Mode mode;
    public final String version;
    final Result[] results = new Result[4];

    public JRubyRun(Mode mode, String version) {
        this.mode = mode;
        this.version = version;
    }

    boolean doesVersionAllow19() {
        return this.version == null ? false : this.version.charAt(2) >= '6';
    }

    public Mode[] asSingleModes() {
        switch (this.mode) {
            case _18_19: {
                if (this.doesVersionAllow19()) {
                    return new Mode[]{Mode._18, Mode._19};
                }
                return new Mode[]{Mode._18};
            }
            case _19: {
                if (this.doesVersionAllow19()) {
                    return new Mode[]{Mode._19};
                }
                return new Mode[0];
            }
        }
        return new Mode[]{this.mode};
    }

    public Result result(Mode mode) {
        return this.results[mode.ordinal()];
    }

    public void setResult(Mode mode, Result result) {
        this.results[mode.ordinal()] = result;
    }

    public String toString(Mode mode) {
        Result result = this.result(mode);
        return "jruby-" + this.version + " mode " + (Object)((Object)mode) + ": " + result.message;
    }

    public static class Result {
        public boolean success;
        public String message;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        _19("--1.9"),
        _18("--1.8"),
        _18_19,
        DEFAULT;

        public final String flag;

        private Mode() {
            this(null);
        }

        private Mode(String flag) {
            this.flag = flag;
        }

        public String toString() {
            return this.flag == null ? "" : this.flag.replace("-", "");
        }
    }
}

