/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.runit;

import de.saumya.mojo.runit.TestScriptFactory;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestScriptFactory
implements TestScriptFactory {
    protected List<String> classpathElements;
    protected File summaryReport;
    protected File outputDir;
    protected File baseDir;
    protected File sourceDir;
    protected File reportPath;
    protected Properties systemProperties;
    protected File gemHome;
    protected File[] gemPaths;

    @Override
    public void setClasspathElements(List<String> classpathElements) {
        this.classpathElements = classpathElements;
    }

    @Override
    public void setSummaryReport(File summaryReport) {
        this.summaryReport = summaryReport;
    }

    @Override
    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir == null ? new File(".") : baseDir;
    }

    @Override
    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    @Override
    public void setReportPath(File reportPath) {
        this.reportPath = reportPath;
    }

    @Override
    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    @Override
    public void setGemHome(File gemHome) {
        this.gemHome = gemHome;
    }

    @Override
    public void setGemPaths(File[] gemPaths) {
        this.gemPaths = gemPaths;
    }

    protected abstract String getScriptName();

    @Override
    public File getScriptFile() {
        return new File(new File(this.outputDir, "bin"), this.getScriptName());
    }

    @Override
    public void emit() throws IOException {
        String script = this.getFullScript();
        File scriptFile = this.getScriptFile();
        scriptFile.getParentFile().mkdirs();
        FileUtils.fileWrite((String)scriptFile.getAbsolutePath(), (String)"UTF-8", (String)script);
        scriptFile.setExecutable(true);
    }
}

