/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.runit;

import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import de.saumya.mojo.runit.AbstractRunitMavenTestScriptFactory;
import de.saumya.mojo.runit.AbstractTestMojo;
import de.saumya.mojo.runit.JRubyRun;
import de.saumya.mojo.runit.Runit18MavenTestScriptFactory;
import de.saumya.mojo.runit.Runit19MavenTestScriptFactory;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;

public class RUnitMojo
extends AbstractTestMojo {
    private final String runitDirectory;
    private final String runitArgs;
    protected boolean skipRunit;

    public RUnitMojo() {
        this.runitDirectory = null;
        this.runitArgs = null;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipTests || this.skipRunit) {
            this.getLog().info((CharSequence)"Skipping RUnit tests");
            return;
        }
        super.execute();
    }

    protected JRubyRun.Result runIt(ScriptFactory factory, JRubyRun.Mode mode, String version) throws IOException, ScriptException, MojoExecutionException {
        File outputfile = new File(this.project.getBuild().getDirectory().replace("${project.basedir}/", ""), "runit.txt");
        AbstractRunitMavenTestScriptFactory scriptFactory = mode == JRubyRun.Mode._18 || mode == JRubyRun.Mode.DEFAULT && (this.jrubySwitches == null || !this.jrubySwitches.contains("--1.9")) ? new Runit18MavenTestScriptFactory() : new Runit19MavenTestScriptFactory();
        scriptFactory.setBaseDir(this.project.getBasedir());
        scriptFactory.setGemHome(this.gemsConfig.getGemHome());
        scriptFactory.setGemPaths(this.gemsConfig.getGemPath());
        scriptFactory.setOutputDir(outputfile.getParentFile());
        scriptFactory.setSystemProperties(this.project.getProperties());
        scriptFactory.setSummaryReport(this.summaryReport);
        scriptFactory.setReportPath(outputfile);
        scriptFactory.setSourceDir(new File(this.launchDirectory(), this.runitDirectory));
        try {
            scriptFactory.setClasspathElements(this.project.getTestClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("error getting classpath", (Exception)((Object)e));
        }
        scriptFactory.emit();
        Script script = factory.newScript(scriptFactory.getCoreScript());
        if (this.runitArgs != null) {
            script.addArgs(this.runitArgs);
        }
        if (this.args != null) {
            script.addArgs(this.args);
        }
        try {
            script.executeIn(this.launchDirectory());
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)"exception in running tests", (Throwable)e);
        }
        JRubyRun.Result result = new JRubyRun.Result();
        String time = null;
        for (Object lineObj : FileUtils.loadFile((File)outputfile)) {
            String line = lineObj.toString();
            if (line.contains("Finished")) {
                time = line.replaceAll("[a-zA-Z]+\\.?", "").trim();
            }
            if (!line.contains("failures")) continue;
            result.message = line;
            int[] vector = new int[5];
            int i = 0;
            String statusLine = line.replaceAll("[a-z]+,?", "");
            for (String n : statusLine.split("\\s+")) {
                vector[i++] = Integer.parseInt(n);
            }
            result.success = vector[ResultEnum.FAILURES.ordinal()] == 0 && vector[ResultEnum.ERRORS.ordinal()] == 0;
            String surefireXml = MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<testsuite time=\"{0}\" errors=\"{1}\" tests=\"{2}\" skipped=\"{3}\" failures=\"{4}\" name=\"{5}\">\n</testsuite>\n", time, vector[ResultEnum.ERRORS.ordinal()], vector[ResultEnum.TESTS.ordinal()], vector[ResultEnum.SKIPS.ordinal()], vector[ResultEnum.FAILURES.ordinal()], this.project.getName());
            this.testReportDirectory.mkdirs();
            String filename = "TEST-runit" + (mode.flag == null ? "" : "-" + version + mode.flag) + ".xml";
            FileUtils.fileWrite((String)new File(this.testReportDirectory, filename).getAbsolutePath(), (String)"UTF-8", (String)surefireXml);
            if (this.summaryReport != null) {
                FileUtils.fileWrite((String)this.summaryReport.getAbsolutePath(), (String)"UTF-8", (String)surefireXml);
            }
            return result;
        }
        result.message = "did not find test summary";
        result.success = false;
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ResultEnum {
        TESTS,
        ASSERTIONS,
        FAILURES,
        ERRORS,
        SKIPS;

    }
}

