/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby.script;

import java.util.ArrayList;
import java.util.List;

public class JRubyVersion {
    private final String version;
    private final String language;

    public JRubyVersion(String version, String language) {
        this.version = version;
        this.language = language;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isVersionLowerThan(Integer ... version) {
        List<Integer> parts = this.extractVersionComponents(this.version);
        for (int i = 0; i < version.length && i < parts.size(); ++i) {
            if (parts.get(i) == version[i]) continue;
            return parts.get(i) < version[i];
        }
        return false;
    }

    private List<Integer> extractVersionComponents(String versionString) {
        if (versionString == null) {
            throw new NumberFormatException();
        }
        String[] parts = versionString.split("\\.");
        ArrayList<Integer> versionComponents = new ArrayList<Integer>();
        for (String part : parts) {
            versionComponents.add(Integer.parseInt(part));
        }
        return versionComponents;
    }

    public boolean isLanguageLowerThan(int major, int minor) {
        List<Integer> parts = this.extractVersionComponents(this.language);
        int majorLanguageVersion = parts.get(0);
        int minorLanguageVersion = parts.get(1);
        if (major == majorLanguageVersion) {
            return minorLanguageVersion < minor;
        }
        return majorLanguageVersion < major;
    }
}

