/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby.script;

import de.saumya.mojo.ruby.Logger;
import de.saumya.mojo.ruby.script.AbstractLauncher;
import de.saumya.mojo.ruby.script.AntLogAdapter;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AntLauncher
extends AbstractLauncher {
    private static final String MAVEN_CLASSPATH = "maven.classpath";
    private static final String DEFAULT_XMX = "-Xmx384m";
    private final Logger logger;
    private final ScriptFactory factory;
    private final Project project;

    AntLauncher(Logger logger, ScriptFactory factory) {
        this.logger = logger;
        this.factory = factory;
        this.project = this.createAntProject();
    }

    @Override
    protected void doExecute(File launchDirectory, List<String> args, File outputFile) {
        Java java = new Java();
        java.setProject(this.project);
        java.setClassname("org.jruby.Main");
        java.setFailonerror(true);
        java.setFork(true);
        java.setDir(launchDirectory);
        for (Map.Entry<String, String> entry : this.factory.environment().entrySet()) {
            Environment.Variable v = new Environment.Variable();
            v.setKey(entry.getKey());
            v.setValue(entry.getValue());
            java.addEnv(v);
        }
        this.logger.debug("java classpath  : " + this.project.getReference(MAVEN_CLASSPATH));
        if (this.factory.environment().size() > 0) {
            this.logger.debug("environment     :");
            for (Map.Entry entry : this.factory.environment().entrySet()) {
                this.logger.debug("\t\t" + (String)entry.getKey() + " => " + (String)entry.getValue());
            }
        }
        for (String string : this.factory.switches.list) {
            java.createArg().setValue(string);
        }
        for (String string : args) {
            java.createArg().setValue(string);
        }
        java.createJvmarg().setValue("-cp");
        java.createJvmarg().setPath((Path)this.project.getReference(MAVEN_CLASSPATH));
        if (this.factory.jrubyJar != null) {
            java.createJvmarg().setValue("-cp");
            java.createJvmarg().setValue(this.factory.jrubyJar.getAbsolutePath());
        }
        if (!this.factory.jvmArgs.matches("-Xmx\\d+m")) {
            java.createJvmarg().setValue(DEFAULT_XMX);
        }
        for (String string : this.factory.jvmArgs.list) {
            java.createJvmarg().setValue(string);
        }
        if (this.factory.jrubyJar != null && this.factory.jrubyJar.equals(this.factory.jrubyStdlibJar)) {
            java.createJvmarg().setValue("-Xbootclasspath/a:" + this.factory.jrubyJar.getAbsolutePath());
        }
        if (this.factory.jrubyJar == null && System.getProperty("jruby.home") != null) {
            Environment.Variable v = new Environment.Variable();
            v.setKey("jruby.home");
            v.setValue(System.getProperty("jruby.home"));
            java.addSysproperty(v);
            File file = System.getProperty("jruby.lib") != null ? new File(System.getProperty("jruby.lib")) : new File(System.getProperty("jruby.home"), "lib");
            File jrubyJar = new File(file, "jruby.jar");
            java.createJvmarg().setValue("-Xbootclasspath/a:" + jrubyJar.getAbsolutePath());
        }
        if (outputFile != null) {
            java.setOutput(outputFile);
        }
        java.execute();
    }

    private Project createAntProject() {
        Project project = new Project();
        Path classPath = new Path(project);
        for (String path : this.factory.classpathElements) {
            if (path.contains("jruby-complete") && this.factory.jrubyJar != null) continue;
            classPath.add(new Path(project, path));
        }
        project.addReference(MAVEN_CLASSPATH, (Object)classPath);
        project.addBuildListener((BuildListener)new AntLogAdapter(this.logger));
        return project;
    }

    @Override
    public void execute(List<String> args) throws ScriptException, IOException {
        this.doExecute(null, args, null);
    }

    @Override
    public void execute(List<String> args, File outputFile) throws ScriptException, IOException {
        this.doExecute(null, args, outputFile);
    }

    @Override
    public void executeIn(File launchDirectory, List<String> args) throws ScriptException, IOException {
        this.doExecute(launchDirectory, args, null);
    }

    @Override
    public void executeIn(File launchDirectory, List<String> args, File outputFile) throws ScriptException, IOException {
        this.doExecute(launchDirectory, args, outputFile);
    }

    @Override
    public void executeScript(String script, List<String> args) throws ScriptException, IOException {
        this.executeScript(script, args, null);
    }

    @Override
    public void executeScript(String script, List<String> args, File outputFile) throws ScriptException, IOException {
        this.executeScript(null, script, args, outputFile);
    }

    @Override
    public void executeScript(File launchDirectory, String script, List<String> args) throws ScriptException, IOException {
        this.executeScript(launchDirectory, script, args, null);
    }

    @Override
    public void executeScript(File launchDirectory, String script, List<String> args, File outputFile) throws ScriptException, IOException {
        args.add(0, "-e");
        args.add(1, script);
        args.add(2, "--");
        this.doExecute(launchDirectory, args, outputFile);
    }
}

