/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby.script;

import de.saumya.mojo.ruby.Logger;
import de.saumya.mojo.ruby.gems.GemsConfig;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.classworlds.ClassRealm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemScriptFactory
extends ScriptFactory {
    public static final String GEM_HOME = "GEM_HOME";
    public static final String GEM_PATH = "GEM_PATH";
    private final GemsConfig gemsConfig;

    public GemScriptFactory(Logger logger, ClassRealm classRealm, File jrubyJar, List<String> classpathElements, boolean fork, GemsConfig config) throws ScriptException, IOException {
        this(logger, classRealm, jrubyJar, jrubyJar, classpathElements, fork, config);
    }

    public GemScriptFactory(Logger logger, ClassRealm classRealm, File jrubyJar, File stdlibJar, List<String> classpathElements, boolean fork, GemsConfig config) throws ScriptException, IOException {
        super(logger, classRealm, jrubyJar, stdlibJar, classpathElements, fork);
        this.gemsConfig = config;
    }

    @Override
    public Map<String, String> environment() {
        HashMap<String, String> result = new HashMap<String, String>(super.environment());
        if (this.gemsConfig.getGemHome() != null) {
            result.put(GEM_HOME, this.gemsConfig.getGemHome().getAbsolutePath().replaceFirst("/[$][{]project.basedir[}]/", "/"));
        }
        if (this.gemsConfig.getGemPath().length > 0) {
            StringBuilder paths = new StringBuilder();
            for (File path : this.gemsConfig.getGemPath()) {
                if (paths.length() > 0) {
                    paths.append(System.getProperty("path.separator"));
                }
                paths.append(path.getAbsolutePath().replaceFirst("/[$][{]project.basedir[}]/", "/"));
            }
            result.put(GEM_PATH, paths.toString());
        }
        return result;
    }

    @Override
    public Script newScriptFromSearchPath(String scriptName) throws IOException {
        File script = new File(this.gemsConfig.getBinDirectory(), scriptName);
        if (script.exists()) {
            Script s = new Script(this);
            s.add(script.getAbsolutePath());
            return s;
        }
        return super.newScriptFromSearchPath(scriptName);
    }
}

