/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby.script;

import de.saumya.mojo.ruby.Logger;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.codehaus.classworlds.ClassRealm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemScriptFactory
extends ScriptFactory {
    public static final String GEM_HOME = "GEM_HOME";
    public static final String GEM_PATH = "GEM_PATH";
    private final File gemHome;
    private final File gemPath;

    public GemScriptFactory(Logger logger, ClassRealm classRealm, File jrubyJar, List<String> classpathElements, boolean fork, File gemHome, File gemPath) throws ScriptException, IOException {
        super(logger, classRealm, jrubyJar, classpathElements, fork);
        if (gemHome != null) {
            this.gemHome = new File(gemHome.getAbsolutePath().replaceFirst("/[$][{]project.basedir[}]/", "/"));
            this.addEnv(GEM_HOME, this.gemHome.getPath());
        } else {
            this.gemHome = null;
        }
        if (gemPath != null) {
            this.gemPath = new File(gemPath.getAbsolutePath().replaceFirst("/[$][{]project.basedir[}]/", "/"));
            this.addEnv(GEM_PATH, this.gemPath.getPath());
        } else {
            this.gemPath = null;
        }
    }

    @Override
    public Script newScriptFromSearchPath(String scriptName) throws IOException {
        File script = new File(new File(this.gemHome, "bin"), scriptName);
        if (script.exists()) {
            return this.newScript(script.getAbsoluteFile());
        }
        return super.newScriptFromSearchPath(scriptName);
    }
}

