/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby.gems;

import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.gems.GemManager;
import de.saumya.mojo.ruby.gems.GemsConfig;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.sonatype.aether.RepositorySystemSession;

public class GemsInstaller {
    private static final String JRUBY_OPENSSL = "jruby-openssl";
    public final GemsConfig config;
    public final ScriptFactory factory;
    private final GemManager manager;
    public static final String GEM_RUBY_COMMAND = "META-INF/jruby.home/bin/gem";

    public GemsInstaller(GemsConfig config, ScriptFactory factory, GemManager manager) {
        this.config = config;
        this.factory = factory;
        this.manager = manager;
    }

    public void installPom(MavenProject pom) throws IOException, ScriptException, GemException {
        this.installGems(pom, null, null);
    }

    public void installPom(MavenProject pom, ArtifactRepository localRepository) throws IOException, ScriptException, GemException {
        this.installGems(pom, null, localRepository);
    }

    public MavenProject installGem(String name, String version, RepositorySystemSession repositorySystemSession, ArtifactRepository localRepository) throws GemException, IOException, ScriptException {
        Artifact artifact;
        List<ArtifactRepository> remoteRepositories;
        if (version == null) {
            remoteRepositories = Collections.singletonList(this.manager.defaultGemArtifactRepository());
            artifact = this.manager.createGemArtifactWithLatestVersion(name, localRepository, remoteRepositories);
        } else {
            remoteRepositories = Collections.singletonList(this.manager.defaultGemArtifactRepositoryForVersion(version));
            artifact = this.manager.createGemArtifact(name, version);
        }
        MavenProject pom = this.manager.buildPom(artifact, repositorySystemSession, localRepository, remoteRepositories);
        this.installPom(pom);
        return pom;
    }

    public void installGems(MavenProject pom, Artifact ensureGem, ArtifactRepository localRepository) throws IOException, ScriptException, GemException {
        Script script = null;
        if (ensureGem != null) {
            if (ensureGem.getFile() == null) {
                this.manager.resolve(ensureGem, localRepository, Collections.singletonList(this.manager.defaultGemArtifactRepositoryForVersion(ensureGem.getVersion())));
            }
            script = this.maybeAddArtifact(script, ensureGem);
        }
        if (pom != null) {
            boolean hasAlreadyOpenSSL = false;
            for (Artifact artifact : pom.getArtifacts()) {
                if (!artifact.getFile().exists()) {
                    this.manager.resolve(artifact, localRepository, pom.getRemoteArtifactRepositories());
                }
                script = this.maybeAddArtifact(script, artifact);
                hasAlreadyOpenSSL = hasAlreadyOpenSSL || artifact.getArtifactId().equals(JRUBY_OPENSSL);
            }
            if (pom.getArtifact().getFile() != null && pom.getArtifact().getFile().isFile()) {
                script = this.maybeAddArtifact(script, pom.getArtifact());
            }
            if (this.config.skipJRubyOpenSSL() && !hasAlreadyOpenSSL) {
                Artifact openssl = this.manager.createGemArtifact(JRUBY_OPENSSL, "0.7");
                this.manager.resolve(openssl, localRepository, pom.getRemoteArtifactRepositories());
                script = this.maybeAddArtifact(script, openssl);
            }
        }
        if (script != null) {
            script.addArg("--bindir", this.config.getBinDirectory());
            if (!this.config.getBinDirectory().exists()) {
                this.config.getBinDirectory().mkdirs();
            }
            script.execute();
        }
    }

    private Script maybeAddArtifact(Script script, Artifact artifact) throws IOException, GemException {
        File gemDir = new File(this.config.getGemsDirectory(), artifact.getArtifactId() + "-" + artifact.getVersion());
        File javaGemDir = new File(gemDir.getPath() + "-java");
        if (artifact.getType().contains("gem") && !gemDir.exists() && !javaGemDir.exists()) {
            if (script == null) {
                script = this.factory.newScriptFromResource(GEM_RUBY_COMMAND).addArg("install").addArg("--ignore-dependencies").addArg(this.booleanArg(this.config.isAddRdoc(), "rdoc")).addArg(this.booleanArg(this.config.isAddRI(), "ri")).addArg(this.booleanArg(this.config.isUserInstall(), "user-install")).addArg(this.booleanArg(this.config.isVerbose(), "verbose"));
            }
            script.addArg(artifact.getFile());
        }
        return script;
    }

    private String booleanArg(boolean flag, String name) {
        return "--" + (flag ? "" : "no-") + name;
    }
}

