/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby.script;

import de.saumya.mojo.ruby.Logger;
import de.saumya.mojo.ruby.script.AbstractLauncher;
import de.saumya.mojo.ruby.script.ScriptException;
import de.saumya.mojo.ruby.script.ScriptFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.classworlds.NoSuchRealmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EmbeddedLauncher
extends AbstractLauncher {
    private static final Class<?>[] No_ARG_TYPES = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];
    private final ClassRealm classRealm;
    private final ScriptFactory factory;
    private final Logger logger;

    public EmbeddedLauncher(Logger logger, ScriptFactory factory) throws ScriptException {
        this.logger = logger;
        this.factory = factory;
        this.classRealm = factory.classRealm != null ? this.cloneClassRealm(factory.jrubyJar, factory.classpathElements, factory.classRealm) : null;
    }

    private ClassRealm cloneClassRealm(File jrubyJar, List<String> classpathElements, ClassRealm classRealm) throws ScriptException {
        ClassRealm newClassRealm;
        for (String classpath : classpathElements) {
            if (!classpath.equals(jrubyJar.getAbsolutePath())) continue;
            return null;
        }
        try {
            ClassRealm jruby;
            try {
                jruby = classRealm.getWorld().getRealm("jruby");
            }
            catch (NoSuchRealmException e) {
                jruby = classRealm.getParent().createChildRealm("jruby");
                jruby.addConstituent(jrubyJar.toURI().toURL());
            }
            try {
                jruby.getWorld().disposeRealm("pom");
            }
            catch (NoSuchRealmException e) {
                // empty catch block
            }
            newClassRealm = jruby.createChildRealm("pom");
            for (String classpath : classpathElements) {
                if (classpath.contains("jruby-complete")) continue;
                newClassRealm.addConstituent(new File(classpath).toURI().toURL());
            }
        }
        catch (DuplicateRealmException e) {
            throw new ScriptException("error in naming realms", (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new ScriptException("hmm. found some malformed URL", e);
        }
        return newClassRealm;
    }

    @Override
    protected void doExecute(File launchDirectory, List<String> args, File outputFile) throws ScriptException, IOException {
        this.doExecute(launchDirectory, outputFile, args, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doExecute(File launchDirectory, File outputFile, List<String> args, boolean warn) throws ScriptException, IOException {
        String currentDir;
        if (launchDirectory != null) {
            currentDir = System.getProperty("user.dir");
            System.err.println("launch directory: " + launchDirectory.getAbsolutePath());
            System.setProperty("user.dir", launchDirectory.getAbsolutePath());
        } else {
            currentDir = null;
        }
        args.addAll(0, this.factory.switches.list);
        if (warn) {
            if (this.factory.javaArgs.list.size() > 0) {
                this.logger.warn("have to ignore java arguments and properties in the current setup");
            }
            if (this.factory.env.size() > 0) {
                this.logger.warn("have to ignore environment settings in the current setup");
            }
        }
        PrintStream output = System.out;
        ClassLoader current = null;
        try {
            int status;
            if (outputFile != null) {
                PrintStream writer = new PrintStream(outputFile);
                System.setOut(writer);
                this.logger.debug("output file: " + outputFile);
            }
            this.logger.debug("args: " + args);
            if (this.classRealm != null) {
                current = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.classRealm.getClassLoader());
            }
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.jruby.Main");
            Object main = clazz.newInstance();
            Method m = clazz.getMethod("run", String[].class);
            long start = System.currentTimeMillis();
            Object result = m.invoke(main, new Object[]{args.toArray(new String[args.size()])});
            long end = System.currentTimeMillis();
            this.logger.debug("time " + (end - start));
            if (result instanceof Integer) {
                status = (Integer)result;
            } else {
                Method statusMethod = result.getClass().getMethod("getStatus", No_ARG_TYPES);
                status = (Integer)statusMethod.invoke(result, NO_ARGS);
            }
            if (status != 0) {
                throw new ScriptException("some error in script " + args + ": " + status);
            }
            if (current != null) {
                Thread.currentThread().setContextClassLoader(current);
            }
        }
        catch (InstantiationException e) {
            try {
                throw new ScriptException(e);
                catch (IllegalAccessException e2) {
                    throw new ScriptException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new ScriptException(e3);
                }
                catch (NoSuchMethodException e4) {
                    throw new ScriptException(e4);
                }
                catch (InvocationTargetException e5) {
                    throw new ScriptException(e5);
                }
            }
            catch (Throwable throwable) {
                if (current != null) {
                    Thread.currentThread().setContextClassLoader(current);
                }
                System.setOut(output);
                if (currentDir != null) {
                    System.setProperty("user.dir", currentDir);
                }
                if (this.classRealm == null) throw throwable;
                try {
                    this.classRealm.getWorld().disposeRealm("pom");
                    throw throwable;
                }
                catch (NoSuchRealmException e6) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        System.setOut(output);
        if (currentDir != null) {
            System.setProperty("user.dir", currentDir);
        }
        if (this.classRealm == null) return;
        try {
            this.classRealm.getWorld().disposeRealm("pom");
            return;
        }
        catch (NoSuchRealmException e) {
            return;
        }
    }

    @Override
    public void executeScript(File launchDirectory, String script, List<String> args, File outputFile) throws ScriptException, IOException {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : this.factory.env.entrySet()) {
            if (entry.getValue() == null) continue;
            buf.append("ENV['").append(entry.getKey()).append("']='").append(entry.getValue()).append("';");
        }
        buf.append(script);
        args.add(0, "-e");
        args.add(1, buf.toString());
        args.add(2, "--");
        this.doExecute(launchDirectory, outputFile, args, false);
    }
}

