/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.gems;

import java.util.regex.Pattern;

public class Maven2GemVersionConverter {
    public static final String DUMMY_VERSION = "999.0.0";
    public static final String DUMMY_PREFIX = "0.0.0-";
    public static final Pattern gemVersionPattern = Pattern.compile("[0-9]+(\\.[0-9a-z]+)*");
    private static final Pattern goodVersionPattern = Pattern.compile("[0-9a-zA-Z-_.]+");
    private static final Pattern numbersOnlyGemVersionPattern = Pattern.compile("[0-9]+(\\.[0-9]+){2}(\\.[0-9]+)*");
    private static final Pattern dummyGemVersionPattern = Pattern.compile("^[^0-9].*");
    private static final Pattern majorOnlyPattern = Pattern.compile("^[0-9]+$");
    private static final Pattern majorMinorOnlyPattern = Pattern.compile("^[0-9]+\\.[0-9]+$");

    public String createGemVersion(String mavenVersion) throws NullPointerException {
        if (mavenVersion == null || mavenVersion.trim().length() == 0) {
            throw new NullPointerException("The passed in mavenVersion cannot be empty!");
        }
        if (dummyGemVersionPattern.matcher(mavenVersion).matches()) {
            if (goodVersionPattern.matcher(mavenVersion).matches()) {
                return this.createGemVersion(DUMMY_PREFIX + mavenVersion);
            }
            return DUMMY_VERSION;
        }
        if (numbersOnlyGemVersionPattern.matcher(mavenVersion).matches()) {
            return mavenVersion;
        }
        mavenVersion = mavenVersion.toLowerCase();
        String mainPart = mavenVersion.replaceAll("[\\-_].*", "");
        String extraPart = mavenVersion.substring(mainPart.length()).replaceAll("[_-][_-]", "-");
        StringBuilder version = new StringBuilder(mainPart);
        if (majorOnlyPattern.matcher(mainPart).matches()) {
            version.append(".0.0");
        } else if (majorMinorOnlyPattern.matcher(mainPart).matches()) {
            version.append(".0");
        }
        version.append(extraPart);
        return version.toString().replaceAll("([0-9]+)([a-z]+)", "$1.$2").replaceAll("([a-z]+)([0-9]+)", "$1.$2").replaceAll("-|_", ".").replaceAll("alpha", "a").replaceAll("beta", "b").replaceAll("gamma", "g").replaceAll("cr", "r").replaceAll("rc", "r").replaceAll("sp", "s").replaceAll("milestone", "m");
    }
}

