/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby.script;

import de.saumya.mojo.ruby.Logger;
import de.saumya.mojo.ruby.ScriptUtils;
import de.saumya.mojo.ruby.script.AntLauncher;
import de.saumya.mojo.ruby.script.Arguments;
import de.saumya.mojo.ruby.script.EmbeddedLauncher;
import de.saumya.mojo.ruby.script.Launcher;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.classworlds.NoSuchRealmException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptFactory {
    public static List<String> NO_CLASSPATH = Collections.emptyList();
    final Arguments switches = new Arguments();
    final Arguments jvmArgs = new Arguments();
    private final Map<String, String> env = new HashMap<String, String>();
    private final File jrubyStdlibJar;
    final Logger logger;
    final ClassRealm classRealm;
    final File jrubyJar;
    final List<String> classpathElements;
    final boolean fork;
    final Launcher launcher;

    public ScriptFactory(Logger logger, ClassRealm classRealm, File jrubyJar, List<String> classpathElements, boolean fork) throws ScriptException, IOException {
        this(logger, classRealm, jrubyJar, jrubyJar, classpathElements, fork);
    }

    public ScriptFactory(Logger logger, ClassRealm classRealm, File jrubyJar, File stdlibJar, List<String> classpathElements, boolean fork) throws ScriptException, IOException {
        this.logger = logger;
        this.jrubyStdlibJar = stdlibJar;
        this.jrubyJar = jrubyJar;
        if (this.jrubyJar != null) {
            this.logger.debug("script uses jruby jar:" + this.jrubyJar.getAbsolutePath());
        }
        this.classpathElements = classpathElements == null ? NO_CLASSPATH : Collections.unmodifiableList(classpathElements);
        this.fork = fork;
        if (classRealm != null) {
            ClassRealm jruby;
            try {
                jruby = classRealm.getWorld().getRealm("jruby");
            }
            catch (NoSuchRealmException e) {
                try {
                    jruby = classRealm.getWorld().newRealm("jruby");
                    if (jrubyJar != null) {
                        jruby.addConstituent(jrubyJar.toURI().toURL());
                    }
                }
                catch (DuplicateRealmException ee) {
                    throw new ScriptException("could not setup classrealm for jruby", (Exception)((Object)ee));
                }
            }
            this.classRealm = jruby;
        } else {
            this.classRealm = null;
        }
        this.launcher = fork ? new AntLauncher(logger, this) : new EmbeddedLauncher(logger, this);
    }

    public Script newScriptFromSearchPath(String scriptName) throws IOException {
        return new Script(this, scriptName, true);
    }

    public Script newScriptFromJRubyJar(String scriptName) throws IOException {
        URL url = new URL("jar:file:" + this.jrubyStdlibJar.getAbsolutePath() + "!/META-INF/jruby.home/bin/" + scriptName);
        try {
            url.openConnection().getContent();
            return new Script(this, url);
        }
        catch (IOException e) {
            return this.newScriptFromResource("META-INF/jruby.home/bin/" + scriptName);
        }
    }

    public Script newScriptFromResource(String scriptName) throws IOException {
        URL url;
        URL uRL = url = this.classRealm != null ? this.classRealm.getClassLoader().getResource(scriptName) : null;
        if (url == null) {
            url = ScriptUtils.getScriptFromResource(scriptName);
        }
        if (url.getProtocol().equals("file")) {
            return new Script(this, url.getPath(), false);
        }
        return new Script(this, url);
    }

    public Script newArguments() {
        return new Script(this);
    }

    public Script newScript(String script) throws IOException {
        return new Script(this, script);
    }

    public Script newScript(File file) {
        return new Script(this, file);
    }

    public void addJvmArgs(String args) {
        this.jvmArgs.parseAndAdd(args);
    }

    public void addSwitch(String name) {
        this.switches.add(name);
    }

    public void addSwitch(String name, String value) {
        this.switches.add(name, value);
    }

    public void addSwitches(String switches) {
        this.switches.parseAndAdd(switches);
    }

    public void addEnv(String name, File value) {
        if (value != null) {
            this.env.put(name, value.getAbsolutePath());
        } else {
            this.env.put(name, null);
        }
    }

    public Map<String, String> environment() {
        return this.env;
    }

    public void addEnv(String name, String value) {
        this.env.put(name, value);
    }

    public void addEnvs(String environmentVars) {
        for (String var : environmentVars.split("\\s+")) {
            int index = var.indexOf("=");
            if (index <= -1) continue;
            this.env.put(var.substring(0, index), var.substring(index + 1));
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getName());
        return buf.toString().trim();
    }
}

