/*
 * Decompiled with CFR 0.152.
 */
package de.saumya.mojo.ruby.rails;

import de.saumya.mojo.ruby.gems.GemException;
import de.saumya.mojo.ruby.gems.GemsInstaller;
import de.saumya.mojo.ruby.rails.GwtOptions;
import de.saumya.mojo.ruby.rails.RailsException;
import de.saumya.mojo.ruby.rails.RailsManager;
import de.saumya.mojo.ruby.script.Script;
import de.saumya.mojo.ruby.script.ScriptException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.RepositorySystem;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.sonatype.aether.RepositorySystemSession;

@Component(role=RailsManager.class)
public class DefaultRailsManager
implements RailsManager {
    private static Map<String, String> DATABASES = new HashMap<String, String>();
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement
    private ProjectBuilder builder;
    @Requirement
    private VelocityComponent velocityComponent;
    @Requirement
    private Logger logger;

    public void initInstaller(GemsInstaller installer, File launchDirectory) throws RailsException, IOException {
        this.patchBootScript(launchDirectory);
        this.setupWebXML(launchDirectory);
        this.setupGemfile(installer, launchDirectory);
    }

    @Deprecated
    private void patchBootScript(File launchDirectory) throws RailsException {
        File boot = new File(new File(launchDirectory, "config"), "boot.rb");
        if (boot.exists() && new File(launchDirectory, "Gemfile.maven").exists()) {
            FileOutputStream bootOut;
            InputStream bootPatched;
            InputStream bootOrig;
            FileInputStream bootIn;
            block5: {
                this.logger.info("DEPRECATED: the use of Gemfile.maven deprecated. use '$ mvn rails:pom' to generate a pom out of the Gemfile");
                bootIn = null;
                bootOrig = null;
                bootPatched = null;
                bootOut = null;
                try {
                    bootIn = new FileInputStream(boot);
                    bootOrig = Thread.currentThread().getContextClassLoader().getResourceAsStream("boot.rb.orig");
                    if (!IOUtil.contentEquals((InputStream)bootIn, (InputStream)bootOrig)) break block5;
                    ((InputStream)bootIn).close();
                    bootOut = new FileOutputStream(boot);
                    bootPatched = Thread.currentThread().getContextClassLoader().getResourceAsStream("boot.rb");
                    IOUtil.copy((InputStream)bootPatched, (OutputStream)bootOut);
                }
                catch (IOException e) {
                    try {
                        throw new RailsException("error patching config/boot.rb", e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(bootIn);
                        IOUtil.close(bootOrig);
                        IOUtil.close(bootPatched);
                        IOUtil.close(bootOut);
                        throw throwable;
                    }
                }
            }
            IOUtil.close((InputStream)bootIn);
            IOUtil.close((InputStream)bootOrig);
            IOUtil.close(bootPatched);
            IOUtil.close((OutputStream)bootOut);
        }
    }

    @Deprecated
    private void setupGemfile(GemsInstaller installer, File launchDirectory) {
        File gemfile = new File(launchDirectory, "Gemfile.maven");
        if (gemfile.exists()) {
            installer.factory.addEnv("BUNDLE_GEMFILE", gemfile);
        }
    }

    public void createNew(GemsInstaller installer, RepositorySystemSession repositorySystemSession, File appPath, String database, String railsVersion, RailsManager.ORM orm, String ... args) throws RailsException, GemException, IOException, ScriptException {
        this.createNew(installer, repositorySystemSession, appPath, database, railsVersion, orm, (String)null, (GwtOptions)null, args);
    }

    public void createNew(GemsInstaller installer, RepositorySystemSession repositorySystemSession, File appPath, String database, String railsVersion, RailsManager.ORM orm, String template, GwtOptions gwt, String ... args) throws RailsException, GemException, IOException, ScriptException {
        File pomFile = new File(appPath, "pom.xml");
        if (pomFile.exists()) {
            throw new RailsException(pomFile + " exists - skip installation of rails");
        }
        if (!installer.config.getGemHome().exists()) {
            installer.config.setGemBase(new File(new File(appPath, "target"), "rubygems"));
        }
        if (railsVersion == null) {
            this.logger.info("NOTE: use rails version 3.0.9 to creates a nice platform independent Gemfile. change the rails version anytime later");
        }
        railsVersion = installer.installGem("rails", railsVersion, repositorySystemSession, this.localRepository()).getVersion();
        if (DATABASES.containsKey(database)) {
            database = DATABASES.get(database);
        }
        Script script = installer.factory.newScript(installer.config.binScriptFile("rails")).addArg("_" + railsVersion + "_").addArg("new");
        if (appPath != null) {
            script.addArg(appPath.getAbsolutePath());
        }
        for (String arg : args) {
            script.addArg(arg);
        }
        if (database != null) {
            script.addArg("-d", database);
        }
        if (repositorySystemSession.isOffline()) {
            this.logger.info("system is offline: using jruby rails templates from jar file - might be outdated");
        }
        if (template != null || gwt != null && gwt.packageName != null) {
            String tmp = this.templateFrom(orm, repositorySystemSession.isOffline(), railsVersion);
            if (tmp != null) {
                System.setProperty("maven.rails.basetemplate", tmp);
            }
            if (template != null) {
                System.setProperty("maven.rails.extratemplate", template);
            }
            if (gwt != null && gwt.packageName != null) {
                System.setProperty("maven.rails.gwt", gwt.packageName);
            }
            script.addArg("-m", this.templateFromResource("templates"));
        } else {
            script.addArg("-m", this.templateFrom(orm, repositorySystemSession.isOffline(), railsVersion));
        }
        script.addArg("--skip-bundle");
        script.execute();
        if (appPath != null) {
            installer.factory.newScriptFromResource("maven/tools/pom_generator.rb").addArg("rails").addArg("Gemfile").executeIn(appPath, new File(appPath, "pom.xml"));
            VelocityContext context = new VelocityContext();
            context.put("railsVersion", (Object)railsVersion);
            this.filterContent(appPath, context, "src/main/webapp/index.html");
            this.filterContent(appPath, context, "src/main/webapp/index.html", "public/index.html", true);
            this.setupWebXML(appPath);
            if (gwt != null && gwt.packageName != null) {
                installer.installGem("activerecord-jdbc" + database + "-adapter", null, repositorySystemSession, this.localRepository());
                installer.installGem("resty-generators", null, repositorySystemSession, this.localRepository());
                this.generate(installer, repositorySystemSession, appPath, "resty:setup", gwt.packageName, this.railsBooleanOption(gwt.session, "session"), this.railsBooleanOption(gwt.menu, "menu"));
            }
        }
    }

    private String railsBooleanOption(boolean option, String name) {
        return "--" + (option ? "" : "skip-") + name;
    }

    private String templateFrom(RailsManager.ORM orm, boolean offline, String railsVersion) {
        switch (orm) {
            case activerecord: {
                if (railsVersion.matches("3.0.[0-9]")) {
                    if (offline) {
                        return this.templateFromResource(orm.name());
                    }
                    return "http://jruby.org/rails3.rb";
                }
                return null;
            }
            case datamapper: {
                if (railsVersion.startsWith("3.0.") || offline) {
                    return this.templateFromResource(orm.name());
                }
                return "http://datamapper.org/templates/rails.rb";
            }
        }
        throw new RuntimeException("unknown ORM :" + (Object)((Object)orm));
    }

    private String templateFromResource(String name) {
        return this.getClass().getResource("/rails-templates/" + name + ".rb").toString().replaceFirst("^jar:", "");
    }

    private void setupWebXML(File launchDirectory) throws RailsException, IOException {
        if (!new File(new File(launchDirectory, "config"), "application.rb").exists()) {
            return;
        }
        VelocityContext context = new VelocityContext();
        context.put("basedir", (Object)launchDirectory.getAbsolutePath());
        if (!new File(launchDirectory, "src/main/webapp/WEB-INF/web.xml").exists()) {
            this.filterContent(launchDirectory, context, "config/web.xml");
        }
        this.filterContent(launchDirectory, context, "target/jetty/override-development-web.xml");
        this.filterContent(launchDirectory, context, "target/jetty/override-production-web.xml");
        this.copyFile(launchDirectory, "src/test/resources/server.keystore");
        this.copyFile(launchDirectory, "config/initializers/java_throwable_monkey_patch.rb");
    }

    private void copyFile(File launchDirectory, String name) throws IOException {
        File file = new File(launchDirectory, name);
        if (!file.exists()) {
            FileUtils.copyURLToFile((URL)this.getClass().getResource("/rails-resources/" + name), (File)file);
        }
    }

    private void filterContent(File app, VelocityContext context, String template) throws RailsException {
        this.filterContent(app, context, template, template, false);
    }

    private void filterContent(File app, VelocityContext context, String template, String targetName, boolean force) throws RailsException {
        File templateFile = new File(app, targetName);
        if (!force && templateFile.exists()) {
            return;
        }
        InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("rails-resources/" + template);
        try {
            if (input == null) {
                throw new FileNotFoundException(template);
            }
            String templateString = IOUtil.toString((InputStream)input);
            templateFile.getParentFile().mkdirs();
            FileWriter fw = new FileWriter(templateFile);
            this.velocityComponent.getEngine().evaluate((Context)context, (Writer)fw, "velocity", templateString);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            throw new RailsException("failed to filter " + template, e);
        }
    }

    public void rake(GemsInstaller installer, RepositorySystemSession repositorySystemSession, File launchDirectory, String environment, String task, String ... args) throws IOException, ScriptException, GemException, RailsException {
        Script script = installer.factory.newScriptFromJRubyJar("rake");
        script.addArgs(task);
        for (String arg : args) {
            script.addArg(arg);
        }
        if (environment != null) {
            script.addArg("RAILS_ENV=" + environment);
        }
        script.executeIn(launchDirectory);
    }

    public void generate(GemsInstaller installer, RepositorySystemSession repositorySystemSession, File launchDirectory, String generator, String ... args) throws IOException, ScriptException, GemException, RailsException {
        Script script = installer.factory.newScript(new File(new File(launchDirectory, "script"), "rails")).addArg("generate").addArg(generator);
        for (String arg : args) {
            script.addArg(arg);
        }
        script.executeIn(launchDirectory);
    }

    public void installGems(GemsInstaller gemsInstaller, RepositorySystemSession repositorySystemSession) throws IOException, ScriptException, GemException, RailsException {
        MavenProject pom;
        ArtifactRepository localRepository = this.localRepository();
        ProjectBuildingRequest pomRequest = new DefaultProjectBuildingRequest().setLocalRepository(localRepository).setRepositorySession(repositorySystemSession).setValidationLevel(30).setResolveDependencies(true);
        try {
            pom = this.builder.build(new File("pom.xml"), pomRequest).getProject();
        }
        catch (ProjectBuildingException e) {
            throw new RailsException("error building the POM", (Exception)((Object)e));
        }
        gemsInstaller.installPom(pom);
    }

    private ArtifactRepository localRepository() throws RailsException {
        ArtifactRepository localRepository;
        try {
            localRepository = this.repositorySystem.createDefaultLocalRepository();
        }
        catch (InvalidRepositoryException e) {
            throw new RailsException("error creating local repository", (Exception)((Object)e));
        }
        return localRepository;
    }

    static {
        DATABASES.put("sqlite", "sqilte3");
        DATABASES.put("postgres", "postgresql");
    }
}

